<?php
/**
 * Copyright 1999 - 2003 by Gero Kohnert
 *
 * @modulegroup bug
 * @module bug_show
 * @package bug
 */
 $tutos['base'] = "../..";
 ini_set("include_path","..");
 include_once 'webelements.p3';
 include_once 'permission.p3';
 include_once 'product.pinc';
 include_once 'task.pinc';
 include_once 'timetrack.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("bugtracking","del");
 loadmodule("bugtracking");

 $gotourl = "bugtracking/bug_overview.php";
 $msg = "";

 $b = new bug($dbconn);

 if ( !isset($_GET['id']) ) {
   $msg .= sprintf($lang['Err0040'],$lang[$b->getType()]);
 } else {
   $b->read($_GET['id']);
   $gotourl = $b->parent->getUrl();
 }
 if ( ! $b->del_ok() ) {
   $msg .= sprintf($lang['Err0023'],$lang[$b->getType()]);
   $gotourl = $b->getUrl();
 }
 if ($msg == "") {
   $dbconn->Begin("WORK");
   $msg .= $b->delete();
   $dbconn->Commit("WORK");
 }

 $gotourl = addMessage($gotourl,$msg,true);
 $gotourl = addSessionKey($gotourl,true);

 Header("Status: 302 Moved Temporarily");
 Header("Location: ". dirname(getBaseUrl()) ."/". $gotourl);
 $dbconn->Close();
 
/*
 *   CVS Info:  $Id: bug_del.php,v 1.3 2004/01/26 10:51:46 schueler Exp $
 *   $Author: schueler $
 */
?>