<?php
/**
 * Copyright 1999 - 2002 by Gero Kohnert
 * finish an open time record
 *
 * @modulegroup timetrack
 * @module timetrack_finish
 * @package timetrack
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';
 include_once 'timetrack.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("timetrack","ins");

 $gotourl = "timetrack_new.php?mode=1";
 $msg = "";
 $tt = new timetrack($dbconn);
 if ( isset($_GET['id']) ) {
   $tt->read($_GET['id']);
   $gotourl= addUrlParameter($gotourl,"id=". $tt->id);
 } else {
   $msg .="Mo ID\n";
 }


 if ( $msg == "" ) {
   # finish the open timetrack
   $end   = new DateTime();
   $tt->setEnd($end);
   $tt->setWorkDay($end);
   $tt->setVolume( ($tt->t_end->getTimeStamp() - $tt->t_start->getTimeStamp()) / 3600.0);
   $dbconn->Begin("WORK");
   $msg .= $tt->save();
   $dbconn->Commit("WORK");
   $gotourl = $tt->ref->getURL();
 }
 $gotourl = addSessionKey($gotourl);
 $gotourl= addUrlParameter($gotourl,"msg=". UrlEncode($msg));

 Header("Status: 302 Moved Temporarily");
 Header("Location: ". getBaseUrl() . $gotourl);
 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: timetrack_finish.php,v 1.5 2002/12/31 14:33:40 gokohnert Exp $
    $Author: gokohnert $
-->