<?php
/**
 * Copyright 1999 - 2002 by Gero Kohnert
 *
 *  CVS Info:  $Id: palm_export.php,v 1.7 2003/02/08 16:39:20 gokohnert Exp $
 *  $Author: gokohnert $
 *
 * @modulegroup palm
 * @module palm_export
 * @package palm
 */
 $tutos['base'] = "../..";
 ini_set("include_path","..");

 include_once 'webelements.p3';
 include_once 'permission.p3';
 include_once 'appointment.pinc';
 include_once 'product.pinc';
 include_once 'task.pinc';


 /* --------------------------------------------------------------------------- */
 /* Check if user is allowed to use it */
 check_user();
 loadmodules('palm','show');
 loadmodule('palm');
 loadlayout();

 /**
  * export data
  */
 class palm_export extends layout {
   /**
    * the data display part
    */
   Function info() {
     global $lang;

     if ( $this->format != "html" ) {
       $this->export();
       return;
     }
     echo $this->error("<blink>THIS IS BETA ! Please backup your Palm before using this Module</blink>");
     echo "<form name=\"palmexport\" action=\"palm_export.php\" method=\"GET\">\n";
     $this->addHidden("format","export");
     echo $this->DataTableStart();
     echo "<tr><th colspan=\"4\">". $lang['PalmExport'] ."</th></tr>\n";
     echo "<tr>\n";
     echo $this->showfieldc($lang['PalmFile'],0,"filename");
     echo "<td colspan=\"3\"><input name=\"filename\" value=\"TUTOSExport.pdb\"></td>\n";
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfieldc($lang['PalmType'],0,"type");
     echo " <td colspan=\"3\">\n";
     echo "  <select name=\"type\">";
     foreach ( $lang['PalmTypes'] as $i => $f ) {
       echo "<option value=\"". $i ."\">". $f ."</option>";
     }
     echo "  </select>";
     echo " </td>\n";
     echo "</tr>\n";

     echo "<tr>\n";
     submit_reset(0,-1,1,1,1,0);
     echo "</tr>\n";
     echo $this->DataTableEnd();
     hiddenFormElements();
     echo $this->getHidden();
     echo "</form>\n";
     echo $this->setfocus("palmexport.filename");
   }
   /**
    * navigation
    */
   Function navigate() {
   }
   /**
    * export
    */
   Function export() {
     global $msg,$lang;


     if ( $_GET['type'] == 3 ) {
       $pdb = new PalmDatebook("test", "test");
       $q = "select * from ". $this->dbconn->prefix ."calendar";
       $result = $this->dbconn->Exec($q);
       $n = $result->numrows();
       $x = 0;
       while ( $x < $n ) {
         $a = new appointment($this->dbconn);
         $a->read_result($result,$x);
         $x++;
         $pdb->GoToRecord('+1');
         $fields = array('Description' => $a->descr,
                         'Date' => Date("Y-m-j",$a->start->getTimeStamp()),
                         'StartTime' => Date("H:i",$a->start->getTimeStamp()),
                         'EndTime' => Date("H:i",$a->end->getTimeStamp())
                        );
         $pdb->SetRecordRaw($fields);
         $pdb->SetRecordAttrib(PDB_RECORD_ATTRIB_PRIVATE | 1);  // Category 1, private record
         unset($a);
       }
       $result->free();
     } else if ( $_GET['type'] == 2 ) {
       $pdb = new PalmAddress("test", "test");
       $labels = array(
                       'Title' => $lang['AdrTitle'],
                       'FirstName' => $lang['AdrFirstName'],
                       'LastName'  => $lang['AdrLastName'],
                       'Phone1'    => $lang['Phone'].'1',
                       'Phone2'    => $lang['Phone'].'2',
                       'Phone3'    => $lang['AdrEmail'].'1',
                       'Phone4'    => $lang['AdrEmail'].'2',
                       'Phone5'    => $lang['AdrFax'],
                       'City'      => $lang['City'],
                       'ZipCode'   => $lang['ZIP'],
                       'Custom1'   => $lang['AdrBirthday'],
                       'Custom2'   => $lang['acc_info1'],
                       'Custom3'   => $lang['acc_info2'],
                       'Custom4'   => 'TUTOS-ID',
       );
       $pdb->setFieldLabels($labels);
       $q = "select * from ". $this->dbconn->prefix ."addresses";
       $result = $this->dbconn->Exec($q);
       $n = $result->numrows();
       $x = 0;
       while ( $x < $n ) {
         $a = new tutos_address($this->dbconn);
         $a->read_result($result,$x);
         $x++;
         if (! $a->see_ok() ) {
           continue;
         }
         $pdb->GoToRecord('+1');
         $fields = array('LastName' => $a->l_name,
                         'FirstName' => $a->f_name,
                         'Title' => $a->title,
                         'Custom1' => $a->birthday->getDate(),
                         'Display' => 1);
         # get the location data if possible
         $a->read_locs_data();
         foreach ($a->location as $i => $f ) {
           $loc = &$a->location[$i];
           $fields['Address'] = $loc->street1 ." ". $loc->street2;
           $fields['City'] = $loc->city;
           $fields['ZipCode'] = $loc->zip;
           $fields['Country'] = $loc->country;
           $fields['Phone1Type'] = PDB_ADDR_LABEL_WORK;
           $fields['Phone2Type'] = PDB_ADDR_LABEL_MOBILE;
           $fields['Phone3Type'] = PDB_ADDR_LABEL_EMAIL;
           $fields['Phone4Type'] = PDB_ADDR_LABEL_OTHER;
           $fields['Phone5Type'] = PDB_ADDR_LABEL_FAX;
           $fields['Phone1'] = $loc->phone_1;
           $fields['Phone2'] = $loc->phone_2;
           $fields['Phone3'] = $loc->email_1;
           $fields['Phone4'] = $loc->email_2;
           $fields['Phone5'] = $loc->fax_1;
           $fields['Custom2'] = $loc->acc_info1;
           $fields['Custom3'] = $loc->acc_info2;
           $fields['Custom4'] = "TUTOS-ID:". $a->id .":". $loc->id;
           break;
         }


         $pdb->SetRecordRaw($fields);
         $pdb->SetRecordAttrib(PDB_RECORD_ATTRIB_PRIVATE | 1);  // Category 1, private record
         unset($a);
       }
       $result->free();
     } else if ( $_GET['type'] == 4 ) {
       # Tasks
       $pdb = new PalmTodoList("test", "test");
       $q = "select * from ". $this->dbconn->prefix ."tasks";
       $result = $this->dbconn->Exec($q);
       $n = $result->numrows();
       $x = 0;
       while ( $x < $n ) {
         $a = new task($this->dbconn);
         $a->read_result($result,$x);
         $x++;
         $fields = array('Description' => $a->name,
                         'Note' => $a->desc,
                         'Completed' => ($a->state == TASK_FINISH),
                         'DueDate' => Date('Y-m-d',$a->s_end->getTimeStamp()),
                         );
         $pdb->GoToRecord('+1');
         $pdb->SetRecordRaw($fields);
         $pdb->SetRecordAttrib(PDB_RECORD_ATTRIB_DIRTY | PDB_RECORD_ATTRIB_PRIVATE | 0);
         unset($a);
       }
       $result->free();
     } else {
       echo  "unknown export type".$_GET['type'] ;
       return;
     }

     Header("Expires:");
     Header("Cache-Control:");
     Header("Pragma:");
     $pdb->DownloadPDB($_GET['filename']);
     return;
   }
   /**
    * prepare
    */
   Function prepare() {
     global $lang;

     $this->name = $lang['PalmExport'];
   }
 }

 $l = new palm_export($current_user);
 $l->display();
 $dbconn->Close();
?>
