<?php
/*
 * Copyright 2002 by Gero Kohnert
 *
 * @modulegroup invoice
 * @module invoice_overview
 * @package invoice
 *
 */
 $tutos['base'] = "../..";
 ini_set("include_path","..");
 include_once 'webelements.p3';
 include_once 'permission.p3';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("invoice","overview");
 loadmodule("invoice");
 loadlayout();

 /**
  * show a overview of invoices
  */
 class invoice_overview extends layout {
   /**
    * display the info
    */
   Function info() {
     global $lang,$tutos;

	 $totals = array();

     $n = $this->result->numrows();
     echo $this->actionformStart("invoice_overview.php");
     echo $this->OverviewTableStart();
     echo "<thead>\n";
     echo "<tr>\n";
     echo $this->orderHeader("name",$lang['InvoiceName'],$this->link2);
     echo $this->orderHeader("",$lang['InvoiceCustomer'],$this->link2);
     echo $this->orderHeader("",$lang['InvoiceReference'],$this->link2);
     echo $this->orderHeader("state",$lang['InvoiceState'],$this->link2);
     echo $this->orderHeader("",$lang['InvPosSum'],$this->link2);
     echo $this->orderHeader("",$lang['ProdCreator'],$this->link2);
     echo $this->orderHeader("creation",$lang['ProdCreationS'],$this->link2);
     if ( $tutos[massupdate] == 1 ) {
       echo "  <th nowrap><input type=\"checkbox\" name=\"checkit\" onClick=\"CheckAll2();\"></th>\n";
     }
     echo "</tr>\n";
     echo "</thead>\n";

     if ( $this->start == -1 ) {
       $a = $n - $tutos[maxshow];
       $end = $n;
       $this->start = $a;
     } else {
       $a = $this->start;
       $end = $this->start + $tutos[maxshow];
     }

     $line = 1;
     while ( ($a < $n) && ($a < $end) ) {
       $c = new invoice($this->dbconn);
       $c->read_result($this->result,$a);
       $a++;
       if ( ! $c->see_ok() ) {
         continue;
       }
       $c->read_ref();

       echo $this->OverviewRowStart($line);
       echo "<td valign=\"top\">". $c->getLink() ."</td>";
       echo "<td valign=\"top\">";
       if ( is_object($c->customer) ) {
         echo $c->customer->getLink();
       } else {
         echo $lang['HistoryDeleted'];
       }
       echo "&nbsp;</td>\n";

       if ( $c->ref != -1 ) {
         echo "<td valign=\"top\">". $c->ref->getLink() ."</td>";
       } else {
         echo "<td valign=\"top\">". $lang['HistoryDeleted'] ."</td>";
       }
       echo "<td valign=\"top\">". $lang['InvoiceStates'][$c->state] ."</td>";
       echo "<td valign=\"top\" align=\"right\">&nbsp;";
       $c->read_pos();
       $sum = $c->getTotal();
       $pre = "";
       foreach($sum as $cur => $val) {
         if ( $val != 0 ) {
           $x = array($val,$cur);
           echo $pre . handle('money',$x,number_format($val,2,$lang['DecPoint'],$lang['ThousandPoint']) ."&nbsp;". $cur);
           $pre = "<br>\n";
         }
       }
       echo "</td>";
       echo "<td valign=\"top\">". $c->creator->getLink() ."</td>";
       echo "<td valign=\"top\">". $c->creation->getDateTime() ."</td>";
       if ( $tutos[massupdate] == 1 ) {
         echo " <td align=\"center\">\n";
         if ( $c->mod_ok() ) {
           echo "<input name=\"mark[]\" type=\"checkbox\" value=\"". $c->id ."\">\n";
         } else {
           echo "-\n";
         }
         echo "</td>\n";
       }
       echo $this->OverviewRowEnd($line++);
       unset($c);
     }

     echo $this->list_navigation($this->link1,7+ $tutos[massupdate],$this->start,$a,$n);
     if ( $tutos[massupdate] == 1 ) {
       echo $this->UpdateRowStart(5);
       echo sprintf($lang['withmarked'],$lang['Invoices']);
       echo "<select name=\"action\">\n";
       echo " <option value=\"-1\" selected>". $lang['ActionNil'] ."</option>\n";
       echo " <option value=\"-2\">". $lang['Delete'] ."</option>\n";
       echo "</select>\n";
       echo $this->UpdateRowEnd(3);
     }
     echo "</tfoot>\n";
     echo $this->OverviewTableEnd();
     echo $this->actionformEnd("bug_overview.php");
     $this->result->free();
   }
   /**
    * navigate
    */
   Function navigate() {
   }
   /**
    * action
    */
   Function action() {
     global $msg,$lang,$_GET;

     @reset($_GET['mark']);
     if ( $_GET['action'] == -2 ) {
       $this->dbconn->Begin("WORK");
       while (list ($key,$val) = @each ($_GET['mark'])) {
         $b = new invoice($this->dbconn);
         $b->read($val);
         if ( $b->id != $val ) {
           continue;
         }
         if ( $b->del_ok() ) {
           $msg .= sprintf($lang['InvDelInfo'], $b->getFullName()) ."<br>";
           $msg .= $b->delete();
         } else {
           $msg .= $b->getLink() .": ". sprintf($lang['Err0023'],$lang[$b->getType()]) ."<br>\n";
         }
         unset($p);
       }
       $this->dbconn->Commit("WORK");
     }
   }
   /**
    * prepare
    */
   Function prepare() {
     global $msg,$lang;
;
     $this->link1 = "invoice/invoice_overview.php";
     $this->q = "SELECT * FROM ". $this->dbconn->prefix ."invoice";
     $pre = " WHERE ";
     $name = "";

     if ( isset($_GET['name']) ) {
       $name = $_GET['name'];
       $this->addHidden("name",$name);
     }
     if ( isset($_GET['link_id']) ) {
       $link_id = $_GET['link_id'];
       $this->addHidden("link_id",$link_id);
     }
     if ( isset($_GET['state']) ) {
       $state = $_GET['state'];
       $this->addHidden("state",$state);
     }
     if ( ($name != "*") && ($name != "") ) {
       $this->q .= $pre . $this->dbconn->Like("name",$name);
       $pre = " AND ";
       $this->link1 = addUrlParameter($this->link1,"name=". UrlEncode($name));
     }

     if ( isset($link_id) ) {
       $ref = getObject($this->dbconn,$link_id);
       if ( ($ref->getType() == "company") || ($ref->getType() == "department")  ) {
         $this->q .= $pre . " customer = ". $link_id;
       } else if ( ($ref->getType() == "product") || ($ref->getType() == "installation")  ) {
         $this->q .= $pre . " link_id = ". $link_id;
       } else {
         $this->q .= $pre . " (link_id = ". $link_id .") OR (customer = ". $link_id .")";
       }
       $pre = " AND ";
       $this->link1 = addUrlParameter($this->link1,"link_id=". UrlEncode($link_id));
     }

     if ( isset($state) ) {
       if ( $state == -2 ) {
         $this->q .= " ". $pre ." state in (3,4,5,6)";
         $pre = " AND ";
       } else if ( $state == -1 ) {
       } else {
         $this->q .= " ". $pre ." state=".$state;
         $pre = " AND ";
       }
       $this->link1 = addUrlParameter($this->link1,"state=". $state);
       # remember this
#       session_register('invsearchstate');
       $_SESSION['invsearchstate'] = $state;
     }

     $this->name = $lang['InvOverview'];
     if (isset($ref) ) {
       $this->name .= ":". $ref->getFullName();
     }

     check_dbacl( $this->q, $this->user->id);

     # sorting
     $xxx = "";
     $this->link2 = $this->link1;
     order_parse($this->q,$this->link1,$xxx,$xxx,"name");

     $this->result = $this->dbconn->Exec($this->q);
     if ( 0 == $this->result->numrows()) {
       $this->redirect = "invoice_select.php?msg=". UrlEncode($lang['Err0048']);
       $this->result->free();
     }

     #menu
     $x = invoice::getSelectLink($this->user,$lang['Search']);
     $this->addMenu($x);
   }
 }

 $l = new invoice_overview($current_user);
 $l->display();
 $dbconn->Close();

?>
<!--
    CVS Info:  $Id: invoice_overview.php,v 1.29 2003/03/02 19:11:01 gokohnert Exp $
    $Author: gokohnert $
-->