#Boa:Dialog:recqueue
#TunaPie (c)2005-2006 James Stone. Released under the GNU GPL.
#
#This program is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation; either version 2 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
#
#Written using Boa-Constructor.
#http://boa-constructor.sourceforge.net/
#
#Version 0.0.4 26/09/06

import wx
import os

def create(parent):
    return recqueue(parent)

[wxID_RECQUEUE, wxID_RECQUEUEDELETEBUTTON, wxID_RECQUEUEOKBUTTON, 
 wxID_RECQUEUEQUEUELIST, 
] = [wx.NewId() for _init_ctrls in range(4)]

class recqueue(wx.Dialog):
    def _init_ctrls(self, prnt):
        # generated method, don't edit
        wx.Dialog.__init__(self, id=wxID_RECQUEUE, name=u'recqueue',
              parent=prnt, pos=wx.Point(296, 167), size=wx.Size(390, 445),
              style=wx.DEFAULT_DIALOG_STYLE, title=u'Scheduled Recordings')
        self.SetClientSize(wx.Size(390, 445))
        self.SetBackgroundStyle(wx.BG_STYLE_SYSTEM)
        self.SetThemeEnabled(True)

        self.queuelist = wx.ListBox(choices=[], id=wxID_RECQUEUEQUEUELIST,
              name=u'queuelist', parent=self, pos=wx.Point(16, 16),
              size=wx.Size(352, 384), style=0)
        self.queuelist.SetThemeEnabled(True)

        self.deleteButton = wx.Button(id=wxID_RECQUEUEDELETEBUTTON,
              label=u'Delete', name=u'deleteButton', parent=self,
              pos=wx.Point(48, 408), size=wx.Size(85, 24), style=0)
        self.deleteButton.SetFont(wx.Font(7, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Helvetica'))
        self.deleteButton.Bind(wx.EVT_BUTTON, self.OnDeleteButtonButton,
              id=wxID_RECQUEUEDELETEBUTTON)

        self.OKbutton = wx.Button(id=wxID_RECQUEUEOKBUTTON, label=u'OK',
              name=u'OKbutton', parent=self, pos=wx.Point(250, 408),
              size=wx.Size(85, 24), style=0)
        self.OKbutton.SetFont(wx.Font(7, wx.SWISS, wx.NORMAL, wx.NORMAL, False,
              u'Helvetica'))
        self.OKbutton.SetThemeEnabled(True)
        self.OKbutton.Bind(wx.EVT_BUTTON, self.OnOKbuttonButton,
              id=wxID_RECQUEUEOKBUTTON)

    def __init__(self, parent):
        self._init_ctrls(parent)
        self.refreshqlist()
        
    def setfontsize(self,newsize):
        size=int(newsize)
        self.deleteButton.SetFont(wx.Font(size-1, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Sans'))
        self.OKbutton.SetFont(wx.Font(size-1, wx.SWISS, wx.NORMAL, wx.NORMAL, False,
              u'Sans'))
    
    def refreshqlist(self):
        input,output=os.popen2('atq')
        olines=output.readlines()
        for item in olines:
            self.queuelist.Append(item)

    def OnDeleteButtonButton(self, event):
        selected=self.queuelist.GetSelection()
        if selected==-1:
            return
        queueevent=self.queuelist.GetStringSelection()
        queueitems=queueevent.split()
        null,null=os.popen4('atrm '+queueitems[0])
        self.queuelist.Clear()
        self.refreshqlist()
        
    def OnOKbuttonButton(self, event):
        self.Close()
