//-*-c++-*-
/**
 Authors: David Auber, Patrick Mary, Morgan Mathiaut
 from the LaBRI Visualization Team
 Email : auber@tulip-software.org
 Last modification : 13/03/2009 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/
#include "tulip/GlMultiPolygon.h"

using namespace std;

namespace tlp {

  static const Color oColor(255,255,255,255);
  static const Color fColor(0,0,0,0);

  GlMultiPolygon::GlMultiPolygon(bool filled, bool outlined,const Color &fillColor, const Color &outlineColor):
    filled(filled),outlined(outlined),fillColor(fillColor),outlineColor(outlineColor) {
  }

  void GlMultiPolygon::addPolygon(const vector<Coord> &poly) {
    polygons.push_back(GlPolygon(filled,outlined));
    GlPolygon *newPolygon=&(*(--polygons.end()));
    for(vector<Coord>::const_iterator it=poly.begin();it!=poly.end();++it) {
      newPolygon->addPoint((*it),fillColor,outlineColor);
    }

    BoundingBox bb=newPolygon->getBoundingBox();
    boundingBox.check(bb.first);
    boundingBox.check(bb.second);
  }

  void GlMultiPolygon::draw(float lod,Camera *camera) {
    for(vector<GlPolygon>::iterator it=polygons.begin();it!=polygons.end();++it) {
      (*it).draw(lod,camera);
    }
  }
  //=====================================================
  void GlMultiPolygon::translate(const Coord& mouvement) {
    boundingBox.first+=mouvement;
    boundingBox.second+=mouvement;
    
    for(vector<GlPolygon>::iterator it=polygons.begin();it!=polygons.end();++it) {
      (*it).translate(mouvement);
    }
  }
  //=====================================================
  void GlMultiPolygon::getXML(xmlNodePtr rootNode) {
  }
  //============================================================
  void GlMultiPolygon::setWithXML(xmlNodePtr rootNode) {
  }

}
