; tucnak.nsi
;
; Install script for Nullsoft Scriptable Install System (NSIS), http://nsis.sf.net 
; 

;--------------------------------

LoadLanguageFile "${NSISDIR}\Contrib\Language files\English.nlf"

; The name of the installer
Name "Tucnak 2.47"

; The file to write
OutFile "TucnakMsvc-2.47.exe"

; The default installation directory
InstallDir "c:\tucnak"

; Registry key to check for directory (so if you install again, it will 
; overwrite the old one automatically)
InstallDirRegKey HKLM "Software\OK1ZIA\tucnak" "Install_Dir"

Icon "tucnak.ico"
UninstallIcon "tucnak.ico"

Crccheck on
XPStyle on

;--------------------------------

; Pages

Page components
Page directory
Page instfiles

UninstPage uninstConfirm
UninstPage instfiles

;--------------------------------


; The stuff to install
Section "Install Tucnak"

    SectionIn 1 2 RO

    ; Set output path to the installation directory.
    SetOutPath $INSTDIR

    ; Put file there
    File "..\src\tucnak.exe"
    File "tucnak.bat"
    File "tucnak.ico"
    File "inpout32.dll"
    File "..\doc\README.win32"
;    File "c:\cygwin\bin\uname.exe"
    File "c:\cygwin\bin\sh.exe"
    File "c:\cygwin\bin\cygglib-2.0-0.dll"
    File "c:\cygwin\bin\cyggthread-2.0-0.dll"
;    File "c:\cygwin\bin\cyghamlib-2.dll"
    File "c:\cygwin\bin\cygiconv-2.dll"
    File "c:\cygwin\bin\cygintl-3.dll"
    File "c:\cygwin\bin\cygintl-8.dll"          ; pro sh.exe, gdb.exe
    File "c:\cygwin\bin\cygncurses-9.dll"       ; pro sh.exe
    File "c:\cygwin\bin\cygreadline6.dll"       ; pro sh.exe
    File "c:\cygwin\bin\cygsndfile-1.dll"
    File "c:\cygwin\bin\cygusb0.dll"
    File "c:\cygwin\bin\cygwin1.dll"
;    File "c:\cygwin\lib\hamlib-*.dll"
;    Delete "$OUTDIR\hamlib-dummy.dll"     ; causes relocation problem

;    File "c:\cygwin\bin\rigctl.exe"
    File "c:\cygwin\bin\gdb.exe"
    File "c:\cygwin\bin\tcl84.dll"
    File "c:\cygwin\bin\tk84.dll"
    File "c:\cygwin\bin\cygncurses-8.dll"


    ; Write the installation path into the registry
    WriteRegStr HKLM Software\OK1ZIA\tucnak "install_dir" "$INSTDIR"

    ; Write the uninstall keys for Windows
    WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\tucnak" "DisplayName" "Tucnak"
    WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\tucnak" "UninstallString" '"$INSTDIR\uninstall.exe"'
	    WriteRegDWORD HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\tucnak" "NoModify" 1
    WriteRegDWORD HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\tucnak" "NoRepair" 1
    WriteUninstaller "uninstall.exe"
  
SectionEnd

; Optional section (can be disabled by the user)
Section "Create shortcut in menu Start"
    CreateDirectory "$SMPROGRAMS\OK1ZIA"
    CreateShortCut "$SMPROGRAMS\OK1ZIA\Tucnak.lnk" "$INSTDIR\tucnak.bat" "" "$INSTDIR\tucnak.ico" 0
    CreateShortCut "$SMPROGRAMS\OK1ZIA\Uninstall Tucnak.lnk" "$INSTDIR\uninstall.exe" "" "$INSTDIR\uninstall.exe" 0
SectionEnd

Section "Create shortcut in Desktop"
    CreateShortCut "$DESKTOP\Tucnak.lnk" "$INSTDIR\tucnak.bat" "" "$INSTDIR\tucnak.ico" 0
SectionEnd

Section "Run Tucnak"
    Exec "$INSTDIR\tucnak.bat"
SectionEnd

;--------------------------------

; Uninstaller

Section "Uninstall"

    ; Remove registry keys
    DeleteRegKey HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\tucnak"
    DeleteRegValue HKLM "Software\OK1ZIA\tucnak" "install_dir"
    DeleteRegKey /ifempty HKLM "Software\OK1ZIA\tucnak"


    ; Remove files and uninstaller
    Delete "$INSTDIR\tucnak.exe"
    Delete "$INSTDIR\tucnak.bat" 
    Delete "$INSTDIR\tucnak.ico"
    Delete "$INSTDIR\inpout32.dll"
    Delete "$INSTDIR\README.win32"
    Delete "$INSTDIR\uname.exe"
    Delete "$INSTDIR\sh.exe"
    Delete "$INSTDIR\cygglib-2.0-0.dll"
    Delete "$INSTDIR\cyggthread-2.0-0.dll"
    Delete "$INSTDIR\cyghamlib-2.dll"
    Delete "$INSTDIR\cygiconv-2.dll"
    Delete "$INSTDIR\cygintl-3.dll"
    Delete "$INSTDIR\cygintl-8.dll"          ; pro sh.exe
    Delete "$INSTDIR\cygncurses-8.dll"       ; pro sh.exe
    Delete "$INSTDIR\cygncurses-9.dll"       ; pro sh.exe
    Delete "$INSTDIR\cygreadline6.dll"       ; pro sh.exe
    Delete "$INSTDIR\cygsndfile-1.dll"
    Delete "$INSTDIR\cygusb0.dll"
    Delete "$INSTDIR\cygwin1.dll"
    Delete "$INSTDIR\uninstall.exe"
    Delete "$INSTDIR\hamlib-*.dll"

    Delete "$INSTDIR\rigctl.exe"
    Delete "$INSTDIR\gdb.exe"
    Delete "$INSTDIR\tcl84.dll"
    Delete "$INSTDIR\tk84.dll"
    Delete "$INSTDIR\cygncurses-8.dll"

    Delete "$SMPROGRAMS\OK1ZIA\Tucnak.lnk"
    Delete "$SMPROGRAMS\OK1ZIA\Uninstall Tucnak.lnk" 

    Delete "$DESKTOP\Tucnak.lnk"

    ; Remove directories used
    RMDir "$SMPROGRAMS\OK1ZIA"
    RMDir "$INSTDIR"

SectionEnd
