/*
    Tucnak - VHF contest log
    Copyright (C) 2002-2006  Ladislav Vaiz <ok1zia@nagano.cz>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "header.h"         

struct rotar *rota,*rotb;

void rot_callback(struct sjob *sjob){
    struct rotar *rot;
    unsigned char *data;
/*    char dummy[255];*/
    
    rot=(struct rotar *)sjob->param;
#if 0
    dbg("rot_callback: ret=%d fce=%d adr=%d data=[",sjob->ret, sjob->fce, sjob->sdev->saddr);
    if (sjob->data){
        int i;
        for (i=0;i<sjob->len;i++) dbg("%02x ", sjob->data[i]);
    }
    dbg("]\n");
    /*log_addf("rot_callback: ret=%d adr=%d len=%d \n",sjob->ret, sjob->sdev->saddr,sjob->len);*/
#endif    

    if (sjob->fce==17){ /* version */
        if (sjob->ret!=0) {
            sd_aprot(sjob->sdev, 17, "", 0, rot_callback, rot);
            return;
        }else{
            sd_aprot(sjob->sdev, 64, "", 0, rot_callback, rot);
        }
        data=sjob->data;

        
        rot->verh=data[3];        
        rot->verl=data[4];        
        rot->identa=data[5];        
    }
    if (sjob->fce==64){
        int qtf;

        /*sd_aprot(sjob->sdev, 64, "", 0, rot_callback, rot);*/
        rot->timer_id=install_timer_(100, rotar_timer, rot);

        if (sjob->ret!=0) return;
        data=sjob->data;
        
        qtf=data[0]+256*data[1];
        rot->elev=(gint16) (data[2]+256*data[3]);
        if (qtf!=rot->qtf){
            rot->qtf=qtf;
#ifdef HAVE_SDL
            if (gfx) gfx->dirtyrot=1;
#endif       
        }
/*        dbg("rot_callback: fce 64, qtf=%d elev=%d\n", rot->qtf, rot->elev);*/
        redraw_later(term);
        
    }
    
}

void rotar_timer(void *xxx){
    struct rotar *rot =(struct rotar*)xxx;
    sd_aprot(rot->sdev, 64, "", 0, rot_callback, rot);
    
}

struct rotar *init_rotar(struct config_rotar *cfg){
    struct rotar *rot;

    if (!cfg) return NULL;
    if (!cfg->rot_type) return NULL;
    if (!cfg->rot_filename) return NULL;

    rot=g_new0(struct rotar, 1);
    
    rot->sdev=sd_open_ttys(sdevlist, cfg->rot_saddr, cfg->rot_filename, cfg->rot_timeout_ms);
    /*dbg("init_rotar rot=%p\n", rot->sdev);*/
    if (!rot->sdev){
        g_free(rot);
        return NULL;
    }
    rot->desc=g_strdup(cfg->rot_desc);
	rot->beamwidth=cfg->rot_beamwidth;
	rot->color=0xffffffff;  /*replaced in rot_update_colors*/
/*	rot->qtf=260+40*cfg->nr;*/
    rot->timer_id=-1;
    
    /* get version */
    sd_aprot(rot->sdev, 17, "", 0, rot_callback, rot);
    return rot;
}

void free_rotar(struct rotar *rot){
    if (rot->timer_id>=0) kill_timer(rot->timer_id);
    g_free(rot->desc);
    free_sd(sdevlist, rot->sdev);
    g_free(rot);
}

int init_rotars(){
    struct rotar *rot;
    struct config_rotar *cfgrot;
    int i;
    char rotchar='A';

    rotars=g_ptr_array_new();
    for (i=0;i<cfg->crotars->len;i++){
        cfgrot=(struct config_rotar*)g_ptr_array_index(cfg->crotars, i);
        if (!cfgrot) continue;
        rot=init_rotar(cfgrot);
        if (!rot) continue;
        rot->rotchar=rotchar++;
        g_ptr_array_add(rotars, rot); 
    }
    return 0;
}

int free_rotars(void){
    int i;
    struct rotar *rot;
    for (i=0;i<rotars->len;i++){
        rot=g_ptr_array_index(rotars, i);
        free_rotar(rot);
    }
    g_ptr_array_free(rotars,1);
    return 0;
}

/* gfx is used invisible in makecol */
#ifdef HAVE_SDL
int rot_update_colors(struct gfx *gfx){
	int i;
	struct rotar *rot;
	
    for (i=0;i<rotars->len;i++){
        rot=g_ptr_array_index(rotars, i);
	
		switch(i%4){
			case 0:
				rot->color=makecol(200,0,0);
				break;
			case 1:
				rot->color=makecol(200,0,200);
				break;
			case 2:
				rot->color=makecol(0,200,0);
				break;
			case 3:
				rot->color=makecol(100,200,100);
				break;
		}
	}
	return 0;
}
#endif

int rot_seek(struct rotar *rot, int uhel){
    char s[10];

    if (!rot) return 0;

    s[0]=uhel&0xff;
    s[1]=(uhel>>8)&0xff;
    sd_aprot(rot->sdev, 65, s, 2, NULL, NULL);
    return 0;
}

struct config_rotar *get_config_rotar_by_number(GPtrArray *crots, int nr){
    struct config_rotar *crot;
    int i;

    for (i=0; i<cfg->crotars->len; i++){
        crot = (struct config_rotar *)g_ptr_array_index(crots, i);
        if (crot->nr==nr) return crot;
    }
    return NULL;   
}

struct rotar *get_rotar(int nr){
    if (nr>=rotars->len) return NULL;
    return (struct rotar*) g_ptr_array_index(rotars, nr);
}



/****************************** rotar dialog ***************************/

static char rotar_qtf_str[EQSO_LEN], rotar_elev_str[EQSO_LEN];
static char rotar_desc1[MAX_STR_LEN], rotar_desc2[MAX_STR_LEN];

void refresh_rotar(void *xxx){
    if (strlen(rotar_qtf_str)>0){
        rot_seek(rotar, atoi(rotar_qtf_str));
    }
    /*dbg("refresh_rotar\n");*/
}

char *rotar_msg[] = {
    CTEXT(T_AZIMUTH),
    CTEXT(T_ELEVATION),
};

void rotar_fn(struct dialog_data *dlg)
{
    struct terminal *term = dlg->win->term;
    int max = 0, min = 0;
    int w, rw;
    int y = -1;

    max_text_width(term, rotar_desc1, &max);
    min_text_width(term, rotar_desc1, &min);
    max_text_width(term, rotar_desc2, &max);
    min_text_width(term, rotar_desc2, &min);
    max_group_width(term, rotar_msg + 0, dlg->items + 0, 1, &max);
    min_group_width(term, rotar_msg + 0, dlg->items + 0, 1, &min);
    max_group_width(term, rotar_msg + 1, dlg->items + 1, 1, &max);
    min_group_width(term, rotar_msg + 1, dlg->items + 1, 1, &min);
    
    max_buttons_width(term, dlg->items + 2, 2, &max);
    min_buttons_width(term, dlg->items + 2, 2, &min);
    
    w = dlg->win->term->x * 9 / 10 - 2 * DIALOG_LB;
    if (w > max) w = max;
    if (w < min) w = min;
    if (w > dlg->win->term->x - 2 * DIALOG_LB - 8 ) w = dlg->win->term->x - 2 * DIALOG_LB - 8;
    if (w < 1) w = 1;
    
    rw = 0;
    y ++;
    dlg_format_text (NULL, term, rotar_desc1, dlg->x+6, &y, w, &rw, COLOR_DIALOG_TEXT, AL_LEFT);
    dlg_format_text (NULL, term, rotar_desc2, dlg->x+6, &y, w, &rw, COLOR_DIALOG_TEXT, AL_LEFT);
    dlg_format_group(NULL, term, rotar_msg + 0, dlg->items + 0, 1, 0, &y, w, &rw);
    dlg_format_group(NULL, term, rotar_msg + 1, dlg->items + 1, 1, 0, &y, w, &rw);
    y++;
    dlg_format_buttons(NULL, term, dlg->items + 2, 2, 0, &y, w, &rw, AL_LEFT);
    
    
    w = rw;
    dlg->xw = w + 2 * DIALOG_LB;
    dlg->yw = y + 2 * DIALOG_TB;

    
    center_dlg(dlg);
    draw_dlg(dlg);
    y = dlg->y + DIALOG_TB;
    y++;
    dlg_format_text (term, term, rotar_desc1, dlg->x+6, &y, w, &rw, COLOR_DIALOG_TEXT, AL_LEFT);
    dlg_format_text (term, term, rotar_desc2, dlg->x+6, &y, w, &rw, COLOR_DIALOG_TEXT, AL_LEFT);
    dlg_format_group(term, term, rotar_msg + 0, dlg->items + 0, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, rotar_msg + 1, dlg->items + 1, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    y++;
    dlg_format_buttons(term, term, dlg->items + 2, 2, dlg->x + DIALOG_LB, &y, w, NULL, AL_LEFT);
    
}   

void rotar_set_desc(void){
    g_snprintf(rotar_desc1, MAX_STR_LEN, "Rotr %c (%d)", rotar->rotchar, rotar->sdev->saddr);
    g_snprintf(rotar_desc2, MAX_STR_LEN, "%s", rotar->desc);
}

int rotar_func(struct dialog_data *data, struct event *ev){
    char rotchar;
      /*  dbg("mouse ev=%d x=%d y=%d b=%d\n", ev->ev, ev->x, ev->y, ev->b); */
    
    switch(ev->ev){
        case EV_KBD:
            if (ev->y & KBD_ALT) break;
            if (ev->y & KBD_CTRL) break;
            rotchar=toupper(ev->x);
            if (rotchar<'A' || rotchar>'Z') {
                return -1;
            }
            if (rotchar<'A' || rotchar-'A'>=rotars->len) {
                return EVENT_PROCESSED;
            }
            /*dbg("rotar %c\n", rotchar);*/

            rotar=get_rotar(rotchar-'A');
            rotar_set_desc();
            resize_terminal();
            return EVENT_PROCESSED;
        
    }
    return -1; /* !EVENT_PROCESSED */
}
        
        

void menu_rotar(struct terminal *term, void *xxx, struct session *ses){

    struct dialog *d;
    int i;

    if (!rotar) rotar=get_rotar(0);
    if (!rotar) return;
    
    rotar_set_desc();
    /*g_snprintf(rotar_qtf_str,  EQSO_LEN, "%d", rotar->qtf);
    g_snprintf(rotar_elev_str, EQSO_LEN, "%d", rotar->elev);*/
    strcpy(rotar_qtf_str, "");
    strcpy(rotar_elev_str, "");

    
    if (!(d = mem_alloc(sizeof(struct dialog) + 55 * sizeof(struct dialog_item)))) return;
    memset(d, 0, sizeof(struct dialog) + 55 * sizeof(struct dialog_item));
    d->title = "Rotator";
    d->fn = rotar_fn;
    d->refresh = (void (*)(void *))refresh_rotar;
    d->refresh_data = (void *)rotar;
    d->handle_event = rotar_func;
    
    d->items[i=0].type = D_FIELD; /* 0 */
    d->items[i].dlen = EQSO_LEN;
    d->items[i].data = rotar_qtf_str;
    
    d->items[++i].type = D_FIELD; 
    d->items[i].dlen = EQSO_LEN;
    d->items[i].data = rotar_elev_str;
    
   

    d->items[++i].type = D_BUTTON; /* 2 */
    d->items[i].gid = B_ENTER;
    d->items[i].fn = ok_dialog;
    d->items[i].text = TEXT(T_OK);
    
    d->items[++i].type = D_BUTTON;
    d->items[i].gid = B_ESC;
    d->items[i].fn = cancel_dialog;
    d->items[i].text = TEXT(T_CANCEL);
    
    
    d->items[++i].type = D_END;
    do_dialog_(term, d, getml(d, NULL));
                               
}

