/*
    Tucnak - VHF contest log
    Copyright (C) 2002-2006  Ladislav Vaiz <ok1zia@nagano.cz>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "header.h"

char *strstates[]={"RUN","SP","REQR","REQS","RUNING","GIVEN"};
char *strccmds[]={"REQ","ACC","REJ","BACK"};

void menu_forcerun(struct terminal *term, void *d, struct session *ses){
    gchar *c;
    struct band *b;
    if (!ctest || !aband) return;
    
    b=aband;
    dbg("forcerun (st=%s)\n", strstates[b->ctrlstate]);
    c=g_strdup_printf("GR %s;%d;%s\n", b->pband, CCMD_REJ,net->myid);
    dbg("   send %s",c);
    rel_write_all(c);
    g_free(c);
    b->ctrlstate=CTRL_RUN;
    redraw_later(term);
}

int can_cq(struct band *b){
    if (!b) return 0;
    return (b->ctrlstate&0x01)==0;
}

int can_tx(struct band *b){
    if (!b) return 0;
    return (b->ctrlstate&0x01)==0 || b->ctrlstate==CTRL_GIVEN;
}


void menu_grabband(struct terminal *term, void *d, struct session *ses){
    gchar *c;
    struct band *b;
    int ctx1,ctx2;
    if (!ctest || !aband) return;
    
    
    b=aband;
    ctx1=can_cq(b);
    dbg("grabband (st=%s)\n", strstates[b->ctrlstate]);
    switch(b->ctrlstate){
        /* RUN */
        case CTRL_RUN:/* mozna poslat CCMD_REJ, aby S&P vychcipali */
            break;
        case CTRL_REQR:
            b->ctrlstate=CTRL_GIVEN;
            c=g_strdup_printf("GR %s;%d;%s\n", b->pband, CCMD_ACC, b->ctrlsp);
            dbg("   send %s",c);
            rel_write_all(c);
            g_free(c);
            break;
        case CTRL_GIVEN:
            break;
        /* S&P */
        case CTRL_SP:
            b->ctrlstate=CTRL_REQS;
            c=g_strdup_printf("GR %s;%d;%s\n", b->pband, CCMD_REQ, net->myid);
            dbg("   send %s",c);
            rel_write_all(c);
            g_free(c);
            break;
        case CTRL_REQS:
        case CTRL_RUNING: /* see ctrl_back */
            b->ctrlstate=CTRL_SP;
            c=g_strdup_printf("GR %s;%d;%s\n", b->pband, CCMD_BACK, net->myid);
            dbg("   send %s",c);
            rel_write_all(c);
            g_free(c);
            break;

    }
    ctx2=can_cq(b);
    if (ctx1 && !ctx2) rx();
    dbg("         (st=%s)\n", strstates[b->ctrlstate]);
    redraw_later(term);
    
}

void net_grab(struct band *b, enum ccmd ccmd, gchar *netid){
    int ctx1,ctx2;
    if (!b) return;
    
    dbg("net_grab (st=%s, cmd=%s, netid=%s)\n",strstates[b->ctrlstate],strccmds[ccmd], netid);
    ctx1=can_cq(b);
    switch(b->ctrlstate){
        /* RUN */
        case CTRL_RUN:
        case CTRL_REQR:
        case CTRL_GIVEN:
            switch(ccmd){
                case CCMD_REQ:
                    b->ctrlstate=CTRL_REQR;
                    CONDGFREE(b->ctrlsp);
                    b->ctrlsp=g_strdup(netid);
                    break;
                case CCMD_BACK:
                    b->ctrlstate=CTRL_RUN;
                    break;
                case CCMD_REJ: /* first "force run mode" */
                    b->ctrlstate=CTRL_SP;
                    break;
                default:
                    break;
            }
            break;

        /* S&P */            
        case CTRL_SP:
        case CTRL_REQS:
        case CTRL_RUNING:
            switch(ccmd){
                case CCMD_ACC:
                    if (strcmp(netid,net->myid)) {
                        b->ctrlstate=CTRL_SP;       /* other S&P become control */
                    }else{
                        b->ctrlstate=CTRL_RUNING;
                    }
                    break;
                case CCMD_REJ:
                    b->ctrlstate=CTRL_SP;
                    break;
                default:
                    break;
            }
            break;
    }
    ctx2=can_cq(b);
    if (ctx1 && !ctx2) rx();
    dbg("         (st=%s)\n", strstates[b->ctrlstate]);
    redraw_later(term);
}

void ctrl_back(struct band *b){
    int ctx1,ctx2;
    gchar *c;
    if (!b) return;

    ctx1=can_cq(b);
    
    switch(b->ctrlstate){
        /* S&P */            
        case CTRL_SP:
        case CTRL_REQS:
        case CTRL_RUNING:
            /* see menu_grabband/CTRL_RUNING */
            b->ctrlstate=CTRL_SP;
            c=g_strdup_printf("GR %s;%d;%s\n", b->pband, CCMD_BACK, net->myid);
            dbg("   send %s",c);
            rel_write_all(c);
            g_free(c);
            break;
        default:
            break;
    }
    ctx2=can_cq(b);
    if (ctx1 && !ctx2) rx();
}


void wkd_tmpqso(struct band *band, enum wt_type type, gchar *str){
    gchar *c;
    if (!ctest || !band || !str) return;
    
    c=g_strdup_printf("WT %s;%s;%d;%s\n", band->pband, net->myid, type, str);
    rel_write_all(c);
    g_free(c);
}

void peer_tx(struct band *band, int tx){
    gchar *c;
    if (!ctest || !band) return;
    
    c=g_strdup_printf("PT %s;%s;%d\n", band->pband, net->myid, tx);
    rel_write_all(c);
    g_free(c);
}

void menu_spy(struct terminal *term, void *d, struct session *ses){
    if (!ctest || !aband) return;

    aband->spymode++;
    if (aband->spymode>=SM_LAST) aband->spymode=SM_INPUTLINE;
    redraw_later(term);
}

void send_inputline(struct band *band){
    gchar *c;
    
    if (!band) return;

    c = g_strdup_printf("WI %s;%s;%s\n", 
            band->pband, 
            net->myid,
            band->il->cdata); 
    rel_write_all(c);
    g_free(c);
}

void free_spypeer(struct spypeer *sp){
    clear_spypeer(sp);
    CONDGFREE(sp->peerid);
    CONDGFREE(sp->operator);
    CONDGFREE(sp->inputline);
    g_free(sp);
}

void free_spypeers(GPtrArray *sps){
    int i;
    
    if (!sps) return;
    
    for (i=0;i<sps->len;i++){
        struct spypeer *sp;
        sp=(struct spypeer *)g_ptr_array_index(sps, i);
        free_spypeer(sp);
    }
    g_ptr_array_free(sps,1);
}

struct spypeer *init_spypeer(GPtrArray *sps, gchar *peerid){
    struct spypeer *sp;

    sp=get_spypeer_by_peerid(sps, peerid);
    if (sp){
        g_ptr_array_remove(sps, sp);
        free_spypeer(sp);
    }

    sp=g_new0(struct spypeer, 1);
    sp->peerid=g_strdup(peerid);
    sp->peertx=-1;
    g_ptr_array_add(sps, sp);
    resize_terminal();
    return sp;
}

struct spypeer *get_spypeer_by_peerid(GPtrArray *sps, gchar *peerid){
    int i;

    for (i=0;i<sps->len;i++){
        struct spypeer *sp;
        sp=(struct spypeer *)g_ptr_array_index(sps, i);
        if (strcmp(sp->peerid, peerid)) continue;
        return sp;
    }
    return NULL;
}

void clear_spypeer(struct spypeer *sp){
    CONDGFREE(sp->callsign);
    CONDGFREE(sp->rsts);
    CONDGFREE(sp->rstr);
    CONDGFREE(sp->qsonrs);
    CONDGFREE(sp->qsonrr);
    CONDGFREE(sp->exc);
    CONDGFREE(sp->locator);
    CONDGFREE(sp->remark);
}

void send_spypeer_request(struct terminal *term, int no, struct session *ses){
    char *peerid,*c;
    gchar **items;
    int i;
    
    log_addf("add_spy '%d'\n",no);

    items = g_strsplit(net->allpeers,";",0);

    for (i=0; items[i]!=NULL;i++){
        if (i==no) goto found;
    }
    goto x;
found:    
    peerid=items[i];
    log_addf("send_spypeer_request: peerid=%s", peerid);
    init_spypeer(aband->spypeers, peerid);

    c=g_strdup_printf("RT %s;%s\n",aband->pband, peerid);
    rel_write_all(c);
    g_free(c);
x:;    
    g_strfreev(items);
}
