/*********************************************************************************
 *  TTCN-3 Parser - A Java based TTCN-3 Parser using ANTLR
 *  Copyright (C) 2000, 2001 Testing Technologies IST GmbH
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *********************************************************************************/
/* -----------------------------------------------------------------------------
 *  DESCRIPTION: TTCN3 Lexer, v1.0.7 Grammer for ANTLR
 *
 *  AUTHOR:      Ina Schieferdecker, Theofanis Vassiliou-Gioles
 *  DATE:        May, 2000
 *
 *  REVISION INFO:
 *      $Revision: 2.0 $ $Date: 2001/06/25 16:16:06 $
 *
 *  Open Issues: 
 *                 - ExtendedAlphaNum
 *                 - FreeText isn't handled at all
 *
 * -----------------------------------------------------------------------------
 */

class TTCN3Lexer extends Lexer;

options {
    exportVocab=TTCN3Lexer;
    testLiterals = false;
    caseSensitive = true;
    k=12;
    defaultErrorHandler=false;
}

tokens 
{
        /* ------------------------------------ Nodes ----------------------------------- */
	ActivateStatement;              AddOp;                              AddressKeyword;
        AddressRef;                     AddressValue;                       
	AllKeyword;
        AllOrSignatureList;             AllOrTypeList;                      AllPort;
        AllowedValues;                  AltConstruct;                       AltGuardChar;
        AltGuardElement;                AltGuardElements;                   AltGuardList;
		AltKeyword;
        And4b;                          And;                                
	AnyOrOmit;
        AnyValue;                       ArrayBounds;                        AnyKeyword;
        ArrayDef;                       ArrayElementConstExpressionList;    
	ArrayElementExpressionList;
        ArrayElementSpec;               ArrayElementSpecList;              
        ArrayExpression;                ArrayOrBitRef;                      
        ArrayValueOrAttrib;             Assignment;                         AssignmentChar;
        AssignmentList;                 AttribKeyword;                      AttribQualifier;
        AttribSpec;                     

	BaseTemplate;                   BasicStatements;
        BeginChar;                      BehaviourStatements;                BinOrMatch;
        BitOp;                          BitStringKeyword;                   BitStringMatch;
        BitStringValue;                 BooleanExpression;                  BooleanKeyword;
        BooleanValue;                   

	CallBodyGuard;                      CallBodyOps;
        CallBodyStatement;              CallBodyStatementList;              CallParameters;
        CallStatement;                  CallTimerValue;                     CatchOpParameter;
        CatchStatement;                 Cell;                               
	CharKeyword;			CharStringKeyword;
        CharStringMatch;                CharStringPattern;
	CharStringValue;                CharStringValueId;
	CheckParameter;			ComponentId;			    
        CheckStatement;                 ClearStatement;                     Colon;
        Comma;                          CommunicationStatements;            Complement;
        ComponentDef;                   ComponentDefList;                   ComponentElementDef;
        ComponentIdentifier;            ComponentRef;                       ComponentType;
        CompoundConstExpression;        CompoundExpression;                 
        ConditionalConstruct;           ConfigSpec;                         ConfigurationOps;
        ConfigurationStatements;        ConnectStatement;                   ConstDef;
        ConstList;                      ConstantExpression;                 
        ControlStatement;
        ControlStatementOrDef;          ControlStatementOrDefList;          
        CreateOp;                       Cstring;                            

	Dash;
        DeactivateStatement;            DefKeyword;                         DefOrFieldRef;
        DefOrFieldRefList;              DefIndentClose;                     DefIndentOpen;
        DefinitiveNameAndNumberForm;    DefinitiveObjIdComponent;           
	DefinitiveObjIdComponentList;
        DerivedDef;                     Direction;                          DisconnectStatement;
        DisplayKeyword;                 DoWhileStatement;                   DoneStatement;
        Dot;                            DoubleColon;                        

	ElseClause;
        ElseIfClause;                   ElseIfClauses;                      ElseStatement;
        EncodeKeyword;                  EndChar;                            EnumDef;
        EnumeratedValue;                Equal;                              Error;
        ExceptionSpec;                  ExceptionTypeList;                  ExpandStatement;
        Expression;                     ExtConstDef;                        ExtFunctionDef;
        ExtendedFieldReference;             ExtensionKeyword;
        ExtraMatchingAttributes;        

	Factor;                         Fail;
        False;                          FieldConstExpressionList;           FieldConstExpressionSpec;
        FieldExpressionList;            FieldExpressionSpec;                
        FieldReference;                 FieldSpec;                          FieldSpecList;
        FieldValueOrAttrib;             
        Final;                          FloatKeyword;                       FloatValue;
        ForStatement;                   FormalPortPar;
        FormalTemplatePar;              FormalTimerPar;                     FormalTypePar;
        FormalValuePar;                 FromClause;                         FunctionActualPar;
        FunctionActualParList;          FunctionBody;                       FunctionDef;
        FunctionFormalPar;
	FunctionInstance;               FunctionLocalDef;                   FunctionLocalInst;
        FunctionRef;                    FunctionStatement;                  FunctionStatementOrDef;
        FunctionStatementOrDefList;     

	GetCallStatement;               GetReplyStatement;		    GetLocalVerdict;
        GlobalModuleId;                 GotoStatement;                      Group;
        GroupDef;                       GuardOp;                            GuardStatement;

        HexOrMatch;                     HexStringKeyword;                   HexStringMatch;
        HexStringValue;                 

	Identifier;                     IfPresentMatch;
        ImportAllSpec;                  ImportConstSpec;                    ImportDef;
        ImportFromSpec;                 ImportFunctionSpec;                 ImportGroupSpec;
        ImportNamedAltSpec;             ImportSignatureSpec;                ImportSpec;
        ImportTemplateSpec;             ImportTestcaseSpec;                 ImportTypeDefSpec;
        InLineTemplate;                 InOutParKeyword;                    InParKeyword;
        Inconc;                         Infinity;                           Initial;                         IntegerKeyword;
        IntegerRange;                   IntegerRangeDef;                    IntegerValue;
        InterleavedAction;              InterleavedConstruct;
        InterleavedGuard;               InterleavedGuardElement;            InterleavedGuardList;

        LParen;                         LabelStatement;                     LanguageSpec;
        LengthMatch;                    Lessorequal;                        Lessthan;
        LogStatement;                   LoopConstruct;                      LowerBound;

	MatchOp;			MatchingSymbol;
        MTCOp;                          MapStatement;                       
        MessageAttribs;                 MessageList;                        Minus;
        MixedAttribs;                   MixedList;                          Mod;
	ModifiesKeyword; 
        ModuleControlPart;              ModuleDefinition;                   ModuleDefinitionsList;
        ModuleDefinitionsPart;          ModuleId;                           ModulePar;
        ModuleParList;                  Moreorequal;                        Morethan;
        MultiWithAttrib;                MultiplyOp;                         

	NameAndNumberForm;
        NamedAltActualPar;              NamedAltActualParList;              NamedAltDef;
        NamedAltFormalPar;              NamedAltFormalParList;              NamedAltInstance;
        NamedAltList;                   NamedAltRef;                        NamedAltRefList;
	NamedKeyword;
        NamedValue;                     NamedValueList;                     None;
        Not4b;                          Not;                                
	NotUsedSymbol;			NotUsedOrExpression;
	NowaitKeyword;
        Notequals;                      Null;                               Number;
        NumberForm;                     

	ObjIdComponent;                 ObjIdComponentList;
        ObjectIdentifierKeyword;        ObjectIdentifierValue;              OctOrMatch;
        OctetStringKeyword;             OctetStringMatch;                   OctetStringValue;
        OmitKeyword;                    OpCall;                             OpValue;
        OptionalKeyword;                Or4b;                               Or;
        OutParKeyword;                  OverrideKeyword; 

	ParRef;                         ParaAssignmentList;
        ParaSpec;                       Pass;                               Plane;
        Plus;                           Port;                               PortCallBody;
        PortCallOp;                     PortCatchOp;                        PortCheckOp;
        PortClearOp;                    PortDef;                            PortDefAttribs;
        PortDefBody;                    PortElement;                        PortGetCallOp;
        PortGetReplyOp;                 PortInstance;                       PortOrAll;
        PortOrAny;                      PortRaiseOp;                        PortReceiveOp;
        PortRedirect;                   PortRedirectWithParam;              PortRef;
        PortReplyOp;                    PortSendOp;                         PortSpec;
        PortStartOp;                    PortStopOp;                         PortTriggerOp;
        PortType;                       
        PredefinedType;                 PredefinedValue;                    Primary;
        ProcOrType;                     ProcOrTypeList;                     ProcedureAttribs;
        ProcedureList;                  Product;                            

	Quadruple;        		QuestionMark;                   

	RParen;                         RaiseStatement;
        RangeOp;                        ReadTimerOp;                        ReceiveParameter;
        ReceiveStatement;               RecordDef;                          RecordOfDef;
        RecordRef;                      RedirectSpec;                       ReferencedType;
        ReferencedValue;                RelOp;                              Rem;
	ReplyStatement;
        ReturnStatement;                Row;
        RunningOp;                      RunningTimerOp;                     RunsOnSpec;

        SUTAction;                      SUTStatements;                      SelfOp;
        SemiColon;                      SendParameter;                      SendStatement;
        SenderSpec;                     SetDef;                             SetLocalVerdict;
        SetOfDef;                       ShiftOp;                            Signature;
        SignatureDef;                   SignatureFormalPar;                 SignatureFormalParList;
        SignatureList;                  SimpleExpression;                   SimpleExpressions;
        SingleConstDef;                 SingleExpression;                   SingleQuote;
        SingleValueOrAttrib;                SingleVarInstance;
        SingleWithAttrib;               Slash;                              SquareClose;
        SquareOpen;                     Star;                               StartStatement;
        StartTCStatement;               StartTimerStatement;                StatementBlock;
        Step;                           StopStatement;                      StopTCStatement;
        StopTimerStatement;             StringAnyValue;			    StringAnyOrOmit;
        StringLength;                   StringMatchOp;
        StringOp;                       		                    StructDefBody;
        StructDefFormalPar;             StructDefFormalParList;             StructFieldDef;
        StructOfDefBody;                StructuredTypeDef;                  SubExpression;
        SubTypeDef;                     SubTypeSpec;                        SystemOp;
        SystemSpec;                     

	TTCN3File; 			TTCN3Module;               	    TTCN3ModuleId;
        TemplateActualPar;              TemplateActualParList;              TemplateBody;
        TemplateDef;                    TemplateFormalPar;                  TemplateFormalParList;
        TemplateInstance;               TemplateKeyword;		    TemplateOps;
	TemplateRef;                    TemplateRefWithParList;
        Term;                           TestcaseActualPar;                  TestcaseActualParList;
        TestcaseDef;                                      
        TestcaseInstance;               TestcaseRef;                        TimeoutStatement;
	TimeoutKeyword;
        TimerInstance;                  TimerOps;                           
	TimerRef;			TimerRefOrAll;			    TimerRefOrAny;
        TimerStatements;                TimerValue;                         ToClause;
        TriggerStatement;               True;                               Type;
        TypeActualPar;                  TypeActualParList;                  TypeDef;
        TypeDefIdentifier;              TypeList;                           TypeReference;

        UnaryOp;                        Underscore;                         UnionDef;
        UnionDefBody;                   UnionFieldDef;                      
	UniversalChar;			UniversalCharString;
        UniversalKeyword;               UnmapStatement;                     UpperBound;

        Value;                          ValueList;                          ValueMatchSpec;
        ValueofOp;			ValueOrRange;                       
	ValueParOrTypePar; 		ValueReference;  
	ValueSpec;
        VarInitialValue;                VarInstance;                        VarList;
        VariableAssignment;             VariableEntry;                      VariableList;
        VariableRef;                    VerdictKeyword;                     VerdictTypeKeyword;
	VerdictOps;
        VerdictStatements;              VerdictValue;                       

	WhileStatement;
        WithAttribList;                 WithStatement;                      

	Xor4b;				Xor; 							


        BSTRING;                        DOT;                                FLOATVALUE;
        HSTRING;                        OSTRING;                            RANGEOP;    

        /* -------------------- Keywords -------------------- */
        ACTION = "action";              ACTIVATE = "activate";          ADDRESS = "address";
        ALL = "all";                    ALT = "alt";                    AND = "and";
        AND4B = "and4b";
        ANY = "any";                    ASN1 = "asn1";                  
        BITSTRING = "bitstring";        BOOLEAN = "boolean";            CALL = "call";
        CAST = "cast";                  CATCH = "catch";                
	CHARKEYWORD = "char";	CHARSTRING = "charstring";
        CHECK = "check";                CLEAR = "clear";                
	COMPLEMENTKEYWORD = "complement";				COMPONENT = "component";
        CONNECT = "connect";            CONST = "const";                CONTROL = "control";
        CREATE = "create";              DEACTIVATE = "deactivate";      DEFAULT = "default";
        DISCONNECT = "disconnect";
        DISPLAY = "display";            DO = "do";                      DONE = "done";
        ELSE = "else";                  ENCODE = "encode";
        ENUMERATED = "enumerated";      ERROR = "error";                EXCEPTION = "exception";
        EXPAND = "expand";              EXTENSION = "extension";        EXTERNAL = "external";
        FAIL = "fail";                  FALSE = "false";                FLOAT = "float";
        FOR = "for";                    FROM = "from";                  FUNCTION = "function";
        GET = "get";                    GETCALL = "getcall";            GETREPLY = "getreply";
        GOTO = "goto";                  GROUP = "group";                
        HEXSTRING = "hexstring";        IF = "if";                      IFPRESENT = "ifpresent";
        IMPORT = "import";              IN = "in";                      INCONC = "inconc";
        INFINITY = "infinity";          INOUT = "inout";                
        INTEGER = "integer";            INTERLEAVE = "interleave";      
	LABEL = "label";                LENGTH = "length";		LANGUAGE="language";
	LOG = "log";                    MAP = "map";			MIXED="mixed";
        MESSAGE = "message";            MOD = "mod";
        MODIFIES = "modifies";          MODULE = "module";              
        MTC = "mtc";                    NAMED = "named";                NONE = "none";
	NONRECURSIVE = "nonrecursive";  
        NOT = "not";                    NOT4B = "not4b";                NOWAIT = "nowait";      
        NULL = "null";                  OBJECTIDENTIFIERKEYWORD = "objid";          
        OCTETSTRING = "octetstring";    OF = "of";                      OMIT = "omit";
        ON = "on";                      OPTIONAL = "optional";          OR = "or";
        OR4B = "or4b";
        OUT = "out";                    OVERRIDEKEYWORD = "override";
	PARAM = "param";                PASS = "pass";
        PORT = "port";                  
        PROCEDURE = "procedure";        RAISE = "raise";
        READ = "read";                  RECEIVE = "receive";            RECORD = "record";
	REM = "rem";
        REPEAT = "repeat";              REPLY = "reply";
        RETURN = "return";              RUNS = "runs";                  RUNNING= "running";
        SELF = "self";                  SEND = "send";                  SENDER = "sender";
        SET = "set";                    SIGNATURE = "signature";        SIZEOF = "sizeof";
        START = "start";                STOP = "stop";                  
        SUT = "sut";                    SYSTEM ="system";               TEMPLATE = "template";
        TESTCASE = "testcase";          TIMEOUT = "timeout";            TIMER = "timer";
        TO = "to";                      TRIGGER = "trigger";            TRUE = "true";
        TTCN3KEYWORD = "TTCN-3";        TYPE = "type";                  TYPEDEFKEYWORD = "typedef";
        UNION = "union";                UNIVERSAL = "universal";        UNMAP = "unmap";
        VALUE = "value";                VAR = "var";                    VERDICT = "verdict";
        VERDICTTYPE = "verdicttype";    WHILE = "while";                WITH = "with";
        XOR = "xor";                    XOR4B = "xor4b";
	MATCH = "match";		VALUEOF = "valueof";
}

WS      
        :       
            (' '
            |       '\t'
            |       '\n'  { newline(); }
            |       '\r'
            )
                { $setType(Token.SKIP); }
        ;

SL_COMMENT : 
        "//" 
        (~'\n')* '\n'
        { _ttype = Token.SKIP; newline(); }
        ;

ML_COMMENT:
                "/*"
                (       { LA(2)!='/' }? '*'
                |       '\n' { newline(); }
                |       ~('*'|'\n')
                )*
                "*/"
                { $setType(Token.SKIP); }
        ;

IDENTIFIER
options {
  testLiterals = true;
  paraphrase = "an identifer";
}
        :       ('a'..'z'|'A'..'Z') ('a'..'z'|'A'..'Z'|'_'|'0'..'9')*
        ;

ASSIGNMENTCHAR 
options {
  paraphrase = "an assignment char ':='";
}

        : ":=" 
        ;

PORTREDIRECTSYMBOL
options {
  paraphrase = "a port redirect symbol '->'";
}
        : "->" 
        ;

BEGINCHAR 
options {
  paraphrase = "a begin char'{'";
}
        : '{'
        ;


CSTRING
options {
  paraphrase = "a cstring";
}
        :       '"'!   
                (   GeneralTextCharacter
                    | Special
                    | '\'' )* '"'!
        ;


STRING
options {
  paraphrase = "a BIN, HEX or OCT";
}
        : 
                ( '\'' ( BIN )* '\'' 'B' ) => '\''! ( BIN )* '\''! 'B'!
                    { _ttype = BSTRING; }
        |       ( '\'' ( HEX )* '\'' 'H' ) => '\''! ( HEX )* '\''! 'H'!
                    { _ttype = HSTRING; }
        |       ( '\'' ( OCT )* '\'' 'O' ) => '\''! ( OCT )* '\''! 'O'!
                    { _ttype = OSTRING; }
        ;

NUMBER
options {
  paraphrase = "a Number";
}
    {boolean isDecimal=false;}
    :   
		".." {_ttype = RANGEOP;}
    |   '.'  {_ttype = DOT;}
        (('0'..'9')+ (EXPONENT)? { _ttype = FLOATVALUE; })?
    |   (   '0' {isDecimal = true;} // special case for just '0'
        |   ('1'..'9') ('0'..'9')*  {isDecimal=true;}       // non-zero decimal
        )
        // only check to see if it's a float if looks like decimal so far
        (   { LA(2)!='.' && LA(3)!='.' && isDecimal}?
            (   '.' ('0'..'9')* (EXPONENT)?
            |   EXPONENT
            )
            { _ttype = FLOATVALUE; }
        )?
    ;


// a couple protected methods to assist in matching floating point numbers
protected
EXPONENT
        :       (('e') | ('E')) ('-')? ('0'..'9')+
        ;

SEMICOLON 
options {
  paraphrase = "a semicolon ';'";
}
        :  ';'
        ;

COMMA 
options {
  paraphrase = "a comma ','";
}
        : ','
        ;

DOUBLECOLON
options {
  paraphrase = "a double colon '::'";
}
        : "::"
        ;

COLON
options {
  paraphrase = "a colon ':'";
}

        : ':'
        ;

UNDERSCORE
options {
  paraphrase = "an underscore '_'";
}
        : '_'
        ;

ENDCHAR
options {
  paraphrase = "an end char '}'";
}
        : '\175'
        ;

SQUAREOPEN 
options {
  paraphrase = "a square bracket open '['";
}
        : '['
        ;

SQUARECLOSE
options {
  paraphrase = "a square bracket close ']'";
}
        : ']'
        ;

LPAREN
options {
  paraphrase = "a left parentheses '('";
}
        : '('
        ;

RPAREN
options {
  paraphrase = "a right parentheses ')'";
}
        : ')'
        ;

LESSTHAN
options {
  paraphrase = "a less than '<'";
}
        : '<'
        ;

MORETHAN
options {
  paraphrase = "a more than ''";
}
        : '>'
        ;

NOTEQUALS
options {
  paraphrase = "a not equals '!='";
}
        : "!="
        ;

MOREOREQUAL
options {
  paraphrase = "a more or equal '>='";
}
        : ">="
        ;

LESSOREQUAL
options {
  paraphrase = "a less or equal '<='";
}
        : "<="
        ;

EQUAL   
options {
  paraphrase = "an equals '=='";
}
        : "=="
        ;

PLUS 
options {
  paraphrase = "a plus '+'";
}
        : '+'
        ;

MINUS 
options {
  paraphrase = "a minus '-'";
}
        : '-'
        ;

STAR
options {
  paraphrase = "a star '*'";
}
        : '*'
        ;

SLASH
options {
  paraphrase = "a slash '/'";
}
        : '/'
        ;

SINGLEQUOTE
options {
  paraphrase = "a single quote '''";
}
        : '\''
        ;

QUESTIONMARK
options {
  paraphrase = "a question mark '?'";
}
        : '?'
        ;

SHIFTLEFT 
options {
  paraphrase = "a shift left operator '<<'";
}
        : "<<"
        ;

SHIFTRIGHT 
options {
  paraphrase = "a shift right operator '>>'";
}
        : ">>"
        ;
    
ROTATELEFT 
options {
  paraphrase = "a rotate left operator '<@'";
}
        : "<@"
        ;

ROTATERIGHT 
options {
  paraphrase = "a rotate right operator '@>'";
}
        : "@>"
        ;

    
STRINGANYVALUE 
options {
  paraphrase = "an ANY Value String '<?>'";
}
        : "<?>"
        ;

STRINGANYOROMIT 
options {
  paraphrase = "an ANY OR OMIT Value String '<*>'";
}
        : "<*>"
        ;

QUOTESYMBOL
options {
  paraphrase = "a quote symbol '<\">'";
}
 
        : "<\">"
;

STRINGOP
options {
  paraphrase = "a string concat operator '&'";
}
 
        : '&'
;


///////////////////
// Lexical Rules
//////////////////

protected 
Zero
        :       '0'
        ;

protected
Nonzeronum
        :       '1' | '2' | '3' | '4' | '5' | '6' | '7' | '8' | '9'
        ;


protected
Nonzeronumber:
        Nonzeronum
     (
        Num
     )*
   ;

protected
Decimalnumber:
     (
        Num
     )*
   ;

protected
Num:
        Zero
     |
        Nonzeronum
   ;


protected
BIN
        :       '0' .. '1'
        ;

protected
HEX
        :       Num | 'A' | 'B' | 'C' | 'D' | 'E' | 'F'| 'a' | 'b' | 'c' | 'd' | 'e' | 'f'
        ;

protected
OCT     : HEX HEX
        ;


protected
Char    
        :       '\3'..'\377'
        ;


protected GeneralTextCharacter 
        :
                    Alphanumeric
                  | OtherCharacter
                  | Space
        ;

protected Alphanumeric 
        :
          Letter
        | Num

        ;

protected Letter :

    UppercaseLetter
  | LowercaseLetter

  ;

protected UppercaseLetter :

  ( 'A' .. 'Z' )

  ;

protected LowercaseLetter :

  ( 'a' .. 'z' )

  
;
protected Special :

    '/'
  | '*'
  | OtherSpecial

  ;

protected OtherSpecial :

    '!' | '#' | '(' | ')' | '+' | ',' | '-'
  | '.' | ':' | ';' | '<' | '=' | '>'
  | '[' | ']' | '{' | '}'

  ;

protected OtherCharacter :

    '$' | '%' | '&' | '?' | '@'
  | '\\' | '^' | '_' | '`' | '|' | '~'

  ;

protected Space :
    '\000' .. '\011'      // Control characters
  | '\n' { newline(); }
  | '\013' .. '\037'      // Control characters
  | ' '
  ;



