/*
 * @(#)plt/Win32.h 1.00 30 November 1999
 *
 * Copyright (c) 2000 Pete Goodliffe (pete.goodliffe@pace.co.uk)
 *
 * This file is part of TSE3 - the Trax Sequencer Engine version 3.00.
 *
 * This library is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

#ifndef TSE3_PLT_WIN32_H
#define TSE3_PLT_WIN32_H

#include "tse3/MidiScheduler.h"

namespace TSE3
{
    namespace Plt
    {
        /**
         * This is the Win32 (Windows) version of the
         * @ref MidiSchedulerFactory. It makes appropriate decisions to deliver
         * you a @ref MidiScheduler that will run under Win32.
         *
         * @short   Win32 MidiScheduler class factory
         * @author  Pete Goodliffe
         * @version 1.00
         */
        class Win32MidiSchedulerFactory : public MidiSchedulerFactory
        {
            public:

                Win32MidiSchedulerFactory();
                virtual ~Win32MidiSchedulerFactory();

                /**
                 * @reimplemented
                 */
                virtual Win32MidiScheduler *createScheduler();

            private:
        };

        /**
         * This is the Win32 (Windows) @ref MidiScheduler implementation.
         *
         * To be honest, at this stage the code is a bit of a joke. It's not
         * even seen a Microsoft platform, let alone a compiler. This
         * implementation is very possible, and it would be interesting if
         * someone wanted to finish off the work I've begun. I've got other
         * things to be doing ATM...
         *
         * @short   Win32 MidiScheduler implemtation
         * @author  Pete Goodliffe
         * @version 0.00
         * @see     MidiScheduler
         * @see     Win32MidiSchedulerFactory
         */
        class Win32MidiScheduler : public MidiScheduler
        {
            public:

                /**
                 * Creates the Win32MidiScheduler object.
                 */
                Win32MidiScheduler() throw (Win32MidiSchedulerException);
                virtual ~Win32MidiScheduler();

                /**
                 * @reimplemented
                 */
                virtual const char *implementationName();

                /**
                 * @reimplemented
                 */
                virtual size_t ports() const;

                /**
                 * @reimplemented
                 */
                virtual const char *portName(size_t port) const;

                /**
                 * @reimplemented
                 */
                virtual const char *portType(size_t port) const;

                /**
                 * @reimplemented
                 */
                virtual bool portReadable(size_t port) const;

                /**
                 * @reimplemented
                 */
                virtual bool portWriteable(size_t port) const;

                /**
                 * @reimplemented
                 */
                virtual void tx(MidiCommand mc);

                /**
                 * @reimplemented
                 */
                virtual void start(Clock startTime);

                /**
                 * @reimplemented
                 */
                virtual void stop(Clock stopTime);

                /**
                 * @reimplemented
                 */
                virtual void moveTo(Clock moveTime, Clock newTime);

                /**
                 * @reimplemented
                 */
                virtual Clock clock();

                /**
                 * @reimplemented
                 */
                virtual int msecs();

                /**
                 * @reimplemented
                 */
                virtual void setTempo(int newTempo, Clock changeTime);

                /**
                 * @reimplemented
                 */
                virtual bool eventWaiting();

                /**
                 * @reimplemented
                 */
                virtual MidiEvent rx();

                /**
                 * @reimplemented
                 */
                virtual void tx(MidiEvent event);

                /**
                 * @reimplemented
                 */
                virtual void txByte(int byte);

            private:
        };
    }
}

#endif
