/*
 * @(#)Win32.cpp 1.00 30NocemberJuly 1999
 *
 * Copyright (c) 2000 Pete Goodliffe (pete.goodliffe@pace.co.uk)
 *
 * This file is part of TSE3 - the Trax Sequencer Engine version 3.00.
 *
 * This library is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

/*
 * NOTE: This has neither been tested or even compiled. I've just had a quick
 *       stab at a Win32 implemetation based on some docs I've found.
 *       In fact, it's pretty half baked ;-)
 */

#include "tse3/platform/Win32.h"

#include <windows.h>

using namespace TSE3;
using namespace TSE3::Plt;


/******************************************************************************
 * Win32MidiSchedulerFactory class
 *****************************************************************************/

Win32MidiSchedulerFactory::Win32MidiSchedulerFactory()
{
}


Win32MidiSchedulerFactory::~Win32MidiSchedulerFactory()
{
}


Win32MidiScheduler *Win32MidiSchedulerFactory::createScheduler()
{
    try
    {
        Win32MidiScheduler *ms = new Win32MidiScheduler();
        cout << "Created new Win32MidiScheduler seccussfully\n";
        return ms;
    }
    catch (Win32MidiSchedulerException)
    {
        cout << "Failed to create a Win32MidiScheduler\n";
        return new NullMidiScheduler();
    }
}


/******************************************************************************
 * Win32MidiScheduler class
 *****************************************************************************/

namespace
{
    HMIDIOUT hMidiOut;
}

Win32MidiScheduler::Win32MidiScheduler() throw (Win32MidiSchedulerException)
: fd(0), devnum(0)
{
    int error = midiOutOpen(&hMidiOut, -1, 0, 0, 0);
    if (error) throw Win32MidiSchedulerExcpetion;
}


Win32MidiScheduler::~Win32MidiScheduler()
{
    // if playing, stop first!
    if (_running) stop(-1);
    midiOutClose(hMidiOut);
}


string &Win32MidiScheduler::implementationName()
{
    static string s("Win32MidiScheduler version 0.00 [dev].");
    return s;
}


void Win32MidiScheduler::tx(MidiCommand mc)
{
    midiShortMsg((int)mc);
}


void Win32MidiScheduler::start(Clock s)
{
    TIMECAPS timecaps;
    timeGetDevCaps(&timecaps, sizeof(timecaps));
    timeBeginPeriod(10);
    startTime = timeGetTime();
    notify(&MidiSchedulerListener::MidiScheduler_Started);
}


void Win32MidiScheduler::stop(Clock t)
{
    timeEndPeriod(10);
    notify(&MidiSchedulerListener::MidiScheduler_Stopped);
}


void Win32MidiScheduler::moveTo(Clock moveTime, Clock newTime)
{
    notify(&MidiSchedulerListener::MidiScheduler_Moved);
}


Clock Win32MidiScheduler::clock()
{
    int time = timeGetTime() - startTime;
    return msToClock(time);
}


int Win32MidiScheduler::msecs()
{
    return timeGetTime() - startTime;
}


void Win32MidiScheduler::setTempo(int newTempo, Clock changeTime)
{
}


bool Win32MidiScheduler::eventWaiting()
{
    return false;
}


MidiEvent Win32MidiScheduler::rx()
{
    return MidiEvent();
}

/**
 * I guess this will do as a callback function?
 */
static extern "C" void callback(int data)
{
    midiOutShortMsg(hMidiOut, data);
}


void Win32MidiScheduler::tx(MidiEvent e)
{
    int msecs = clockToMs(e,time);
    if (msecs > timeGetTime())
        timeSetEvent(msecs-timeGetTime(), 10, callback, (int)e.data, TIME_ONE_SHOT);
    else
        tv(MidiEvent.data);
}


void Win32MidiScheduler::txByte(int byte)
{
}
