/*
 * @(#)Unix.cpp 3.00 16 October 2000
 *
 * Copyright (c) 2000 Pete Goodliffe (pete.goodliffe@pace.co.uk)
 *
 * This file is part of TSE3 - the Trax Sequencer Engine version 3.00.
 *
 * This library is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

#include "tse3/plt/Unix.h"

#ifdef CONFIG_H
#include "config.h"
#endif

#include "tse3/plt/OSS.h"
#include "tse3/plt/Alsa.h"

#ifdef TSE3_WITH_ARTS
#include "tse3/plt/Arts.h"
#endif

#include "tse3/util/MidiScheduler.h"

#include "tse3/Error.h"

using namespace TSE3::Plt;

UnixMidiSchedulerFactory::UnixMidiSchedulerFactory(bool c)
: plt(UnixPlatform_Alsa), cplt(UnixPlatform_Null), canReturnNull(c)
{
}


UnixMidiSchedulerFactory::~UnixMidiSchedulerFactory()
{
}


TSE3::MidiScheduler *UnixMidiSchedulerFactory::createScheduler()
{
    TSE3::MidiScheduler *ms = 0;
    switch (plt)
    {
        case UnixPlatform_OSS:
        {
            ms = createOSS();
            if (!ms)
            {
                ms = createAlsa();
            }
            break;
        }
        case UnixPlatform_Alsa:
        {
            ms = createAlsa();
            if (!ms)
            {
                ms = createOSS();
            }
            break;
        }
        case UnixPlatform_Arts:
        {
            ms = createArts();
            if (!ms)
            {
                ms = createAlsa();
            }
            if (!ms)
            {
                ms = createOSS();
            }
            break;
        }
        default:
        {
            break;
        }
    }
    if (!ms)
    {
        if (canReturnNull)
        {
            ms = new TSE3::Util::NullMidiScheduler();
        }
        else
        {
            throw MidiSchedulerError(MidiSchedulerCreateErr);
        }
    }
    return ms;
}


TSE3::MidiScheduler *UnixMidiSchedulerFactory::createOSS()
{
    TSE3::MidiScheduler *ms = 0;
    try
    {
        // Create the scheduler
        ms = new OSSMidiScheduler();
        cplt = UnixPlatform_OSS;
    }
    catch (...)
    {
    }
    return ms;
}


TSE3::MidiScheduler *UnixMidiSchedulerFactory::createAlsa()
{
    TSE3::MidiScheduler *ms = 0;
    try
    {
        // Create the scheduler
        ms = new AlsaMidiScheduler();
        cplt = UnixPlatform_Alsa;
    }
    catch (...)
    {
    }
    return ms;
}


TSE3::MidiScheduler *UnixMidiSchedulerFactory::createArts()
{
    TSE3::MidiScheduler *ms = 0;
#ifdef TSE3_WITH_ARTS
    try
    {
        // Create the scheduler
        ms = new ArtsMidiScheduler();
        cplt = UnixPlatform_Arts;
    }
    catch (...)
    {
    }
#endif
    return ms;
}
