/*
 * @(#)MidiScheduler.cpp 3.00 20 May 1999
 *
 * Copyright (c) 2000 Pete Goodliffe (pete.goodliffe@pace.co.uk)
 *
 * This file is part of TSE3 - the Trax Sequencer Engine version 3.00.
 *
 * This library is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

#include "tse3/MidiScheduler.h"

using namespace TSE3;

/******************************************************************************
 * muldiv function
 *****************************************************************************/

int TSE3::Impl::muldiv(int val, int num, int div)
{
    int acc_d, acc_r, val_d, val_r;

    acc_d = acc_r = 0;
    val_d = num / div;
    val_r = num % div;
    while (val > 0)
    {
        if (val & 1)
        {
            acc_d += val_d;
            acc_r += val_r;
            if (acc_r >= div)
            {
                acc_r -= div;
                ++acc_d;
            }
        }
        val   >>= 1;
        val_d <<= 1;
        val_r <<= 1;
        if (val_r >= div)
        {
            val_r -= div;
            ++val_d;
        }
    }
    if (acc_r >= (div >> 1))
    {
        ++acc_d;
    }
    return acc_d;
}


/******************************************************************************
 * MidiSchedulerFactory class
 *****************************************************************************/

MidiSchedulerFactory::MidiSchedulerFactory()
{
}


MidiSchedulerFactory::~MidiSchedulerFactory()
{
}


/******************************************************************************
 * MidiScheduler class
 *****************************************************************************/

MidiScheduler::MidiScheduler()
: _tempo(120), startClock(0), restingClock(0), _running(false),
  _remote(false), shifted(false),
  _shiftNote(24 /*C2*/), _playNote(26 /*D2*/),
  _stopNote(28 /*E2*/), _recordNote(29 /*F2*/)
{
}


MidiScheduler::~MidiScheduler()
{
}


void MidiScheduler::remoteControl(MidiEvent &e)
{
    // TODO Handle MIDI start and stop and song pos messages
    if (_remote)
    {
        if (!shifted && e.data.status == MidiCommand_NoteOn
            && e.data.data1 == _shiftNote)
        {
            shifted = true;
        }
        else if (shifted && e.data.status == MidiCommand_NoteOn
                 && e.data.data1 == _playNote)
        {
            MidiScheduler::start();
        }
        else if (shifted && e.data.status == MidiCommand_NoteOn
                 && e.data.data1 == _stopNote)
        {
            stop(-1);
        }
        else
        {
            shifted = false;
        }
    }
}

