
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h> 
#include <sys/stat.h> 
#include <stdio.h>

#include <gtk/gtk.h>
#include <glib.h>
#include <string.h>

#include <libintl.h>
#define _(x) gettext(x)
#include <locale.h>

#include "rdpfile.h"
#include "support.h"
#include "connect.h"


static void tsc_print_help ();
static void tsc_print_version ();


int
main (int argc, char *argv[])
{
  gint i;
  gchar *rdp_file_name = "";
  rdp_file *rdp = NULL;

  gtk_set_locale ();
  gtk_init (&argc, &argv);

  #ifdef TSCLIENT_DEBUG
  printf ("debugging messages are on\n");
  #endif

  setlocale (LC_ALL, "");
  bindtextdomain (PACKAGE, PACKAGE_LOCALE_DIR);
  bind_textdomain_codeset (PACKAGE, "UTF-8");
  textdomain (PACKAGE);

  #ifdef TSCLIENT_DEBUG
  printf ("gtk default language: %s\n", gtk_get_default_language ());
  #endif

  add_pixmap_directory (PACKAGE_DATA_DIR "/pixmaps/tsclient/");

  // make sure our dirs & files exist
  tsc_check_files ();

  if (g_file_test (g_build_path ("/", tsc_home_path(), "default.tsc", NULL), G_FILE_TEST_EXISTS)) {
    rdp_file_name = g_build_path ("/", tsc_home_path(), "default.tsc", NULL);
  } else if (g_file_test (g_build_path ("/", tsc_home_path(), "last.tsc", NULL), G_FILE_TEST_EXISTS)) {
    rdp_file_name = g_build_path ("/", tsc_home_path(), "last.tsc", NULL);
  }

  // start at 1 because 0 contains binary name
  for (i = 1; i < argc; i++) {
    if (strcmp("--help", argv[i]) == 0 || strcmp("-h", argv[i]) == 0) {
      tsc_print_help ();
      return 0;
    }
    if (strcmp("--version", argv[i]) == 0 || strcmp("-v", argv[i]) == 0) {
      tsc_print_version ();
      return 0;
    }
    if (strcmp("-x", argv[i]) == 0) {
      if (g_file_test (argv[i+1], G_FILE_TEST_EXISTS)) {
        rdp_file_name = argv[i+1];
        rdp = g_new0 (rdp_file, 1);
        rdp_file_init (rdp);
        rdp_file_load (rdp, rdp_file_name);
        //printf ("\n\nrdp_file_name: %s\n\n", rdp_file_name);
        if (tsc_launch_remote (rdp, 1) == 0) {
          g_free (rdp);
          return 0;
        }
      }
    }
    if (g_file_test (argv[i], G_FILE_TEST_EXISTS)) {
      rdp_file_name = argv[i];
      continue;
    }
  }

  // create the main window
  create_frmConnect ();

  // Get the last.tsc for last used settings and load
  if (strlen (rdp_file_name) > 0) {
    rdp = g_new0 (rdp_file, 1);
    rdp_file_init (rdp);
    rdp_file_load (rdp, rdp_file_name);
    rdp_file_set_screen (rdp, gConnect);
    g_free (rdp);
    g_free (rdp_file_name);
  }

  gtk_main ();
  return 0;
}

void tsc_print_help () {

  printf ("\n");
  printf ("  Usage: tsclient [OPTION]... [FILE]...\n\n");
  printf ("  FILE           an rdp format file containing options\n");
  printf ("  -h, --help     display this help and exit\n");
  printf ("  -v, --version  output version information and exit\n");
  printf ("  -x FILE        launch rdesktop with options specified in FILE\n");
  printf ("\n");
  return;

}


void tsc_print_version () {

  printf ("\n");
  printf ("  Terminal Server Client for GNOME\n");
  printf ("  a frontend for rdesktop\n");
  printf ("  tsclient version "VERSION"\n");
  printf ("\n");
  return;

}

