#include "castringlist.h"



/** Constructor.
*/
CAStringList::CAStringList( char separator ) {
    this->list = "";
    this->separator = separator;
}



/** Constructor.
*/
CAStringList::CAStringList( const char* list, char separator ) {
    this->list = list;
    this->separator = separator;
}



/** Destructor.
*/
CAStringList::~CAStringList() {}



/** Count.
*/
int
CAStringList::count() {
    int ret=1;

    for( int i=0; i<list.get_length(); ++i ) {
        if( list.get_string()[i]==separator ) {
            ++ret;
        }
    }

    return ret;
}



/** Returns item number 'which' of the list.
    \param maxLen Max length of the sting to return. Default: 128
*/
char*
CAStringList::getItem( int which, int maxLen ) {
    int i = 0,
            j = 0;
    int found = 0;
    item = "";

    while( i<list.get_length() && found<which ) {
        if( list.get_string()[i]==separator ) {
            ++found;
        }
        ++i;
    }

    j = list.find( '~', i );

    if( j==-1 ) {
        j = list.get_length();
    }

    item = list.mid( i, j-i );

    return item.get_string();
}



// EOF
