#include <stdio.h>

#include "calineedit.h"
#include "caresources.h"
#include "catrophy.h"

/** Constructor.
    \param text The initial text of the edit.
    \param x    X-Coordinate (left or right)
    \param x    Y-Coordinate (top)
    \param letters Number of letters (max)
    \param alignment Alignment of text
    \param font Font to use for the text
*/
CALineEdit::CALineEdit( const char* text,
                        int letters,
                        Alignment alignment,
                        CL_Font* font )
        : CAWidget( alignment ) {
    if( CA_APP->debug ) std::cout << "CALineEdit() begin" << std::endl;

    this->text = text;
    this->letters = letters;
    this->font = font;
    cursor = this->text.get_length();

    char wString[letters];
    for( int i=0; i<letters-1; ++i ) wString[i] = 'W';
    wString[letters] = '\0';
    resize( font->get_text_width( wString ), font->get_height() );

    if( CA_APP->debug ) std::cout << "CALineEdit() end" << std::endl;
}



/** Destructor.
*/
CALineEdit::~CALineEdit() {}



/** Displays the line edit.
    \param active Display in an active state (cursor visible)
*/
void
CALineEdit::display( bool active ) {
    static float frame = 0.0;
    CA_RES->advanceAnimation( &frame, 1, 1.0 );

    switch( alignment ) {
    case Left:
        font->print_left( left, top, text );
        if( active && frame>0.5 ) {
            font->print_left( left + font->get_text_width( text.mid( 0, cursor ) ),
                              top, "|" );
        }
        break;

    case Right:
        font->print_right( right, top, text );
        if( active && frame>0.5 ) {
            font->print_right( right - font->get_text_width( text.right( text.get_length()-cursor ) ) + 3,
                               top, "|" );
        }
        break;

    case Center:
        // To implement.

        break;
    }
}



/** Handles the key inputs.
*/
void
CALineEdit::handleKey( const CL_Key &key ) {
    char dummy[256];

    switch( key.id ) {
    case CL_KEY_RIGHT:
        if( CA_APP->sound ) CA_RES->effectMenu->play( 1 );
        if( cursor<text.get_length() ) ++cursor;
        break;

    case CL_KEY_LEFT:
        if( CA_APP->sound ) CA_RES->effectMenu->play( 1 );
        if( cursor>0 ) --cursor;
        break;

    case CL_KEY_HOME:
        if( CA_APP->sound ) CA_RES->effectMenu->play( 1 );
        cursor=0;
        break;

    case CL_KEY_END:
        if( CA_APP->sound ) CA_RES->effectMenu->play( 1 );
        cursor=text.get_length();
        break;

    case CL_KEY_BACKSPACE:
        if( cursor>0 ) {
            if( CA_APP->sound ) CA_RES->effectMenu->play( 1 );
            --cursor;
            sprintf( dummy,
                     "%s%s",
                     text.mid(0,cursor).get_string(),
                     text.right(text.get_length()-cursor-1).get_string() );
            text = dummy;
        }
        break;

    case CL_KEY_DELETE:
        if( cursor<text.get_length() ) {
            if( CA_APP->sound ) CA_RES->effectMenu->play( 1 );
            sprintf( dummy,
                     "%s%s",
                     text.mid(0,cursor).get_string(),
                     text.right(text.get_length()-cursor-1).get_string() );
            text = dummy;
        }
        break;

    default:
        if( key.ascii!=-1 ) {
            if( text.get_length()<letters ) {
                if( CA_APP->sound ) CA_RES->effectMenu->play( 1 );
                sprintf( dummy,
                         "%s%c%s",
                         text.mid(0,cursor).get_string(),
                         key.ascii,
                         text.right(text.get_length()-cursor).get_string() );
                text = dummy;
                ++cursor;
            }
        }
        break;
    }
}


// EOF
