/*

Copyright (C) 2001  Gopal Narayanan <gopal@astro.umass.edu>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
USA.

*/

/* 
 * setup_transgui - Puts up window for all the transmission lines
 */


#include <stdlib.h>
#include <stdio.h>
#include <gtk/gtk.h>
#include <string.h>
#include <math.h>
#include <sys/stat.h>

#include <config.h>
#include "setup.h"

void
setup_transgui (int ttype, GtkWidget *parent, trans_win *twin)
{
  GtkWidget *vbox;
  GtkWidget *label;
  GtkTooltips *tooltips,*ctooltips,*ptooltips,*etooltips,*btooltips;
  short row, col;
  gchar *textentry;
  GtkWidget *labelbox;
  GtkWidget *drawingbox;
  GtkWidget *scrolledwin;
  GtkWidget *hbox2;
  GtkWidget *table;
  gfloat defaultval;
  struct stat statbuf;
  trans_label *tlabel;
  trans_value *tvalue;
  GtkWidget *hboxtop;
  GtkWidget *hboxbot;
  GtkWidget *hbox3;
  gchar *drawing_filename;
  gchar *image_dir;


  /* allocate and setup labels */
  tlabel = g_malloc(sizeof(*tlabel));
  setup_label(ttype, tlabel);

  /* allocate and setup default values */
  tvalue = g_malloc(sizeof(*tvalue));
  setup_values(ttype, tvalue);


  /*allocate memory for textentry */
  if ((textentry = (char *) malloc(20*sizeof(char)))  == NULL){
    perror("help text error: malloc");
    return;
  }

#ifdef HAVE_IMLIB

  if ((image_dir = (char *) malloc(50*sizeof(char))) == NULL){
    perror("image dir malloc error:");
    return;
  }

  if ((drawing_filename = (char *) malloc(50*sizeof(char))) == NULL){
    perror("drawing filename malloc error:");
    return;
  }

#endif

  /* Add a vbox and hbox to start the packing */
  main_body_window = gtk_vbox_new (FALSE, 5);

  hboxtop = gtk_hbox_new (FALSE, 5);
  vbox = gtk_vbox_new (FALSE, 5);

  /* pack these in the parent window */
  /*  gtk_container_add (GTK_CONTAINER (parent), main_body_window);*/
  gtk_box_pack_start (GTK_BOX (parent), main_body_window, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (main_body_window), hboxtop, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (hboxtop), vbox, TRUE, TRUE, 0);

  switch (ttype) {
  case MICROSTRIP :
    twin->drawing_frame = gtk_frame_new ("Microstrip");
    break;
  case RECTWAVEGUIDE :
    twin->drawing_frame = gtk_frame_new ("Rectangular Waveguide");
    break;
  case COAX :
    twin->drawing_frame = gtk_frame_new ("Coaxial Line");
    break;
  case C_MICROSTRIP :
    twin->drawing_frame = gtk_frame_new ("Coupled Microstrip");
    break;
  }
    
  gtk_container_add (GTK_CONTAINER (vbox), twin->drawing_frame);

  /* Grab the filename for drawing */

#ifdef HAVE_IMLIB
  sprintf (image_dir, "%s/transcalc/images/",DATADIR);    
/*  sprintf(image_dir, "../images/");*/
  if (stat(image_dir, &statbuf)) {
    perror("image dir does not exist");
    exit (-1);
  }

  strcpy(drawing_filename,image_dir);
  
  switch (ttype){
  case MICROSTRIP:
    strcat (drawing_filename,"microstrip.jpg");
    break;
  case RECTWAVEGUIDE:
    strcat (drawing_filename,"rectwaveguide.jpg");
    break;
  case COAX:
    strcat (drawing_filename,"coax.jpg");
    break;
  case C_MICROSTRIP:
    strcat (drawing_filename,"c_microstrip.jpg");
    break;
  }

  free(image_dir);

  if (drawing_filename) {
    drawingbox = gtk_hbox_new (TRUE, 0);
    pack_image_in_box ( drawingbox, drawing_filename);
    gtk_container_add (GTK_CONTAINER (twin->drawing_frame),
		       drawingbox);
    gtk_widget_show (drawingbox);
  }
  free(drawing_filename);

#else
  gtk_widget_set_usize (twin->drawing_frame, 300, -1);

#endif  /* ifdef HAVE_IMLIB */

  gtk_widget_show (twin->drawing_frame);



  /* The substrate parameters frame */

  twin->subparam_frame = gtk_frame_new ("Substrate Parameters");
  gtk_container_add (GTK_CONTAINER (vbox), twin->subparam_frame);
  gtk_widget_set_usize (twin->subparam_frame,300,-1);
  scrolledwin = gtk_scrolled_window_new (NULL, NULL);
  gtk_container_border_width(GTK_CONTAINER(scrolledwin), 5);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwin),
                                     GTK_POLICY_AUTOMATIC,
                                     GTK_POLICY_AUTOMATIC);
  gtk_container_add (GTK_CONTAINER (twin->subparam_frame), 
		     scrolledwin);
  gtk_widget_set_usize (twin->subparam_frame,-1,200);
  gtk_widget_show (scrolledwin);
  

  /* Make a table of NUMSUBPARS rows and 3 columns */
  twin->subparam_table = gtk_table_new (NUMSUBPARS, 3, TRUE);
  gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW (scrolledwin), 
					 twin->subparam_table);
  tooltips = gtk_tooltips_new ();

  for (row = 0; row < NUMSUBPARS; row++) {
    for (col = 0; col < 3; col++) {
      switch (col) {
      case 0:
	/* Since tooltips need to be on widgets with event capability
	 * use eventbox to locate labels and tooltips */
	labelbox = gtk_event_box_new ();
	label = gtk_label_new (tlabel->substrate_label_name[row]);
	gtk_widget_set_usize(label,10,-1);
	gtk_container_add (GTK_CONTAINER (labelbox), label);
	gtk_table_attach_defaults (GTK_TABLE (twin->subparam_table), 
			       labelbox, col, (col+1), row, (row+1));
	gtk_tooltips_set_tip (tooltips, labelbox, 
			      tlabel->stooltips_helptext[row], NULL);
	gtk_widget_show (label);
	gtk_widget_show (labelbox);
	break;

      case 1 :
	twin->subparam_text[row] = gtk_entry_new_with_max_length (10);
	switch (ttype) {
	case MICROSTRIP :
	  switch (row) {
	  case 2 :
	  case 3 :
	  case 4 :
	  case 7 :
	    defaultval = tvalue->subparams_value[row] * 
	      conv_length[LENGTH_MIL][length_unit];
	    break;
	  default:
	    defaultval = tvalue->subparams_value[row];
	    break;
	  }
	  break;
	case RECTWAVEGUIDE :
	  defaultval = tvalue->subparams_value[row];
	  break;
	case COAX :
	  defaultval = tvalue->subparams_value[row];
	  break;
	case C_MICROSTRIP :
	  switch (row) {
	  case 2 :
	  case 3 :
	  case 4 :
	  case 7 :
	    defaultval = tvalue->subparams_value[row] * 
	      conv_length[LENGTH_MIL][length_unit];
	    break;
	  default:
	    defaultval = tvalue->subparams_value[row];
	    break;
	  }
	  break;

	}

	sprintf(textentry,"%g", (float) defaultval);
	gtk_widget_set_usize(twin->subparam_text[row],10,-1);
	gtk_entry_set_text (GTK_ENTRY (twin->subparam_text[row]), textentry);
	gtk_table_attach_defaults (GTK_TABLE (twin->subparam_table), 
				   twin->subparam_text[row], col, (col+1), row, (row+1));
	gtk_widget_show (twin->subparam_text[row]);
	if (defaultval == -1.0) {
	  gtk_entry_set_text (GTK_ENTRY (twin->subparam_text[row]), "");
	  gtk_widget_set_sensitive ( GTK_WIDGET (GTK_ENTRY (twin->subparam_text[row])), FALSE);	  
	}
	break;
	
      case 2:
	twin->subparam_combo[row] = GTK_WIDGET (setup_combo_widget (SUBPARAMTYPE, row));
	gtk_table_attach_defaults (GTK_TABLE (twin->subparam_table), 
				   twin->subparam_combo[row], col, (col+1), row, (row+1));
	gtk_widget_set_usize(twin->subparam_combo[row],4,-1);
	gtk_widget_show (twin->subparam_combo[row]);
	break;
      }
    }
    gtk_signal_connect (GTK_OBJECT (twin->subparam_text[row]), "changed",
			GTK_SIGNAL_FUNC (setstatus), twin);

  }
  
  gtk_tooltips_enable (GTK_TOOLTIPS (tooltips));
  gtk_widget_show (twin->subparam_table);

  gtk_widget_show (twin->subparam_frame);
  gtk_widget_show (vbox);


  /* Now comes the component frame */


  /* new vbox for next column*/
  vbox = gtk_vbox_new (FALSE, 5);
  gtk_box_pack_start (GTK_BOX (hboxtop), vbox, TRUE, TRUE, 0);  

  twin->component_param_frame = gtk_frame_new ("Component Parameters");
  gtk_container_add (GTK_CONTAINER (vbox), twin->component_param_frame);

  scrolledwin = gtk_scrolled_window_new (NULL, NULL);
  gtk_container_border_width(GTK_CONTAINER(scrolledwin), 5);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwin),
                                     GTK_POLICY_AUTOMATIC,
                                     GTK_POLICY_AUTOMATIC);
  gtk_container_add (GTK_CONTAINER (twin->component_param_frame), 
		     scrolledwin);
  gtk_widget_show (scrolledwin);

  /* Make a table of 3 rows and 3 columns */
  twin->component_param_table = gtk_table_new (NUMCOMPPARS, 3, TRUE);

  /*
  gtk_container_add (GTK_CONTAINER (twin->component_param_frame), 
		     twin->component_param_table);
  */
  gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW (scrolledwin), 
					 twin->component_param_table);

  ctooltips = gtk_tooltips_new ();

  for (row = 0; row < NUMCOMPPARS; row++) {
    for (col = 0; col < 3; col++) {
      switch (col) {
      case 0 :
	/* Since tooltips need to be on widgets with event capability
	 * use eventbox to locate labels and tooltips */
	labelbox = gtk_event_box_new ();
	label = gtk_label_new (tlabel->component_label_name[row]);
	gtk_container_add (GTK_CONTAINER (labelbox), label);
	gtk_widget_set_usize(label,10,-1);
	gtk_table_attach_defaults (GTK_TABLE (twin->component_param_table), 
			       labelbox, col, (col+1), row, (row+1));
	gtk_tooltips_set_tip (ctooltips, labelbox, 
			      tlabel->ctooltips_helptext[row], NULL);
	gtk_widget_show (label);
	gtk_widget_show (labelbox);
	break;

      case 1 :
	twin->component_param_text[row] = gtk_entry_new_with_max_length (10);
	switch (row) {
	case 0 :
	  defaultval = tvalue->component_params_value[row] * 
	    conv_freq[FREQ_GHZ][freq_unit];
	  break;
	default:
	  defaultval = tvalue->component_params_value[row];
	  break;
	}

	sprintf(textentry,"%g", (float) defaultval);
	gtk_entry_set_text (GTK_ENTRY (twin->component_param_text[row]), textentry);
	gtk_widget_set_usize(twin->component_param_text[row],10,-1);
	gtk_table_attach_defaults (GTK_TABLE (twin->component_param_table), 
				   twin->component_param_text[row], col, (col+1), row, (row+1));
	gtk_widget_show (twin->component_param_text[row]);
	if (defaultval == -1.0) {
	  gtk_entry_set_text (GTK_ENTRY (twin->component_param_text[row]), "");
	  gtk_widget_set_sensitive ( GTK_WIDGET (GTK_ENTRY (twin->component_param_text[row])), FALSE);	  
	}
	break;
	
      case 2 :
	twin->component_param_combo[row] = GTK_WIDGET (setup_combo_widget (COMPPARAMTYPE, row));
	gtk_table_attach_defaults (GTK_TABLE (twin->component_param_table), 
				   twin->component_param_combo[row], col, (col+1), row, (row+1));
	gtk_widget_set_usize(twin->component_param_combo[row],4,-1);
	gtk_widget_show (twin->component_param_combo[row]);
	
	break;
      }
    }
    
    gtk_signal_connect (GTK_OBJECT (twin->component_param_text[row]), "changed",
			  GTK_SIGNAL_FUNC (setstatus), twin);
  }

  gtk_widget_show (twin->component_param_table);

  gtk_widget_show (twin->component_param_frame);



  /* The physical parameters frame */

  twin->physical_param_frame = gtk_frame_new ("Physical Parameters");
  gtk_container_add (GTK_CONTAINER (vbox), twin->physical_param_frame);

  gtk_widget_set_usize (twin->physical_param_frame,300,100);

  scrolledwin = gtk_scrolled_window_new (NULL, NULL);
  gtk_container_border_width(GTK_CONTAINER(scrolledwin), 5);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwin),
                                     GTK_POLICY_AUTOMATIC,
                                     GTK_POLICY_AUTOMATIC);
  gtk_container_add (GTK_CONTAINER (twin->physical_param_frame), 
		     scrolledwin);
  gtk_widget_show (scrolledwin);


  /* Make a table of NUMPHYSPARS rows and 3 columns */
  twin->physical_param_table = gtk_table_new (NUMPHYSPARS, 4, TRUE);

  /*  gtk_container_add (GTK_CONTAINER (scrolledwin), 
		     twin->physical_param_table);
  */
  gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW (scrolledwin), 
					 twin->physical_param_table);
  ptooltips = gtk_tooltips_new ();

  for (row = 0; row < NUMPHYSPARS; row++) {
    for (col = 0; col < 4; col++) {
      switch (col) {
      case 0 :
	/* Since tooltips need to be on widgets with event capability
	 * use eventbox to locate labels and tooltips */
	labelbox = gtk_event_box_new ();
	label = gtk_label_new (tlabel->physical_label_name[row]);
	gtk_widget_set_usize(label,10,-1);
	gtk_container_add (GTK_CONTAINER (labelbox), label);
	gtk_table_attach_defaults (GTK_TABLE (twin->physical_param_table), 
			       labelbox, col, (col+1), row, (row+1));
	gtk_tooltips_set_tip (ptooltips, labelbox, 
			      tlabel->ptooltips_helptext[row], NULL);
	gtk_widget_show (label);
	gtk_widget_show (labelbox);
	break;

      case 1 :
	twin->physical_param_text[row] = gtk_entry_new_with_max_length (10);
	switch (ttype) {
	case MICROSTRIP :
	  switch (row) {
	  case 0 :
	  case 1 :
	    defaultval = tvalue->physical_params_value[row] * 
	      conv_length[LENGTH_MIL][length_unit];
	    break;
	  default:
	    defaultval = tvalue->physical_params_value[row];
	    break;
	  }
	  break;
	case RECTWAVEGUIDE :
	case COAX :
	  switch (row) {
	  case 0 :
	  case 1 :
	  case 2 :
	    defaultval = tvalue->physical_params_value[row] * 
	      conv_length[LENGTH_MIL][length_unit];
	    break;
	  default:
	    defaultval = tvalue->physical_params_value[row];
	    break;
	  }
	case C_MICROSTRIP :
	  switch (row) {
	  case 0 :
	  case 1 :
	  case 2 :
	    defaultval = tvalue->physical_params_value[row] * 
	      conv_length[LENGTH_MIL][length_unit];
	    break;
	  default:
	    defaultval = tvalue->physical_params_value[row];
	    break;
	  }
	  break;
	default:
	  fprintf(stderr, "setup_transgui: unknown transmission line type!\n");
	  break;
	}
	  
	sprintf(textentry,"%g", (float) defaultval);
	gtk_widget_set_usize(twin->physical_param_text[row],10,-1);
	gtk_entry_set_text (GTK_ENTRY (twin->physical_param_text[row]), textentry);
	gtk_table_attach_defaults (GTK_TABLE (twin->physical_param_table), 
				   twin->physical_param_text[row], col, (col+1), row, (row+1));
	gtk_widget_show (twin->physical_param_text[row]);
	if (defaultval == -1.0) {
	  gtk_entry_set_text (GTK_ENTRY (twin->physical_param_text[row]), "");
	  gtk_widget_set_sensitive ( GTK_WIDGET (GTK_ENTRY (twin->physical_param_text[row])), FALSE);
	}
	break;
	
      case 2 :
	twin->physical_param_combo[row] = GTK_WIDGET (setup_combo_widget (PHYSPARAMTYPE, row));
	gtk_table_attach_defaults (GTK_TABLE (twin->physical_param_table), 
				   twin->physical_param_combo[row], col, (col+1), row, (row+1));
	gtk_widget_set_usize(twin->physical_param_combo[row],4,-1);
	gtk_widget_show (twin->physical_param_combo[row]);

	break;
      case 3 :
	switch(row) {
	case 0 :
	case 1 :
	  twin->physical_param_fix[row] = gtk_button_new_with_label("Fix");
	  gtk_table_attach_defaults (GTK_TABLE (twin->physical_param_table), 
				     twin->physical_param_fix[row], col, (col+1), 
				     row, (row+1));	  
	  /* gtk_widget_set_sensitive (GTK_WIDGET (twin->physical_param_fix[row]), FALSE);*/
	  gtk_widget_show (twin->physical_param_fix[row]);
	  break;
	default: 
	  break;
	}
	break;
      }
    }

    gtk_signal_connect (GTK_OBJECT (twin->physical_param_text[row]), "changed",
		      GTK_SIGNAL_FUNC (setstatus), twin);
  }

  gtk_tooltips_enable (GTK_TOOLTIPS (tooltips));
  gtk_widget_show (twin->physical_param_table);

  gtk_widget_show (twin->physical_param_frame);

  /* Put Analbutton & synbuttons in place */
  hbox2 = gtk_hbox_new (FALSE, 5);
  gtk_box_pack_start (GTK_BOX (vbox), hbox2, FALSE, FALSE, 0);  

  btooltips = gtk_tooltips_new ();

  table = gtk_table_new (1, 2 , TRUE);
  gtk_container_add (GTK_CONTAINER (hbox2), table);

  twin->Analbutton = gtk_button_new_with_label ("Analyze");
  gtk_table_attach_defaults (GTK_TABLE (table),
			     twin->Analbutton, 0, 1, 0, 1);

  gtk_tooltips_set_tip (btooltips, twin->Analbutton,
			"Derive Electrical Parameters", NULL);
  gtk_widget_show(twin->Analbutton);

  twin->Synbutton = gtk_button_new_with_label ("Synthesize");
  gtk_table_attach_defaults (GTK_TABLE (table),
			     twin->Synbutton, 1, 2, 0, 1);  

  gtk_tooltips_set_tip (btooltips, twin->Synbutton,
			"Synthesize Physical Parameters", NULL);
  gtk_widget_show(twin->Synbutton);
  gtk_widget_show(table);
  gtk_widget_show (hbox2);
  gtk_tooltips_enable (GTK_TOOLTIPS (btooltips));


  /* The electrical parameters frame */

  twin->electrical_param_frame = gtk_frame_new ("Electrical Parameters");
  gtk_container_add (GTK_CONTAINER (vbox), twin->electrical_param_frame);

  gtk_widget_set_usize (twin->electrical_param_frame,300,-1);

  scrolledwin = gtk_scrolled_window_new (NULL, NULL);
  gtk_container_border_width(GTK_CONTAINER(scrolledwin), 5);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwin),
                                     GTK_POLICY_AUTOMATIC,
                                     GTK_POLICY_AUTOMATIC);
  gtk_container_add (GTK_CONTAINER (twin->electrical_param_frame), 
		     scrolledwin);
  gtk_widget_show (scrolledwin);

  /* Make a table of NUMPHYSPARS rows and 3 columns */
  twin->electrical_param_table = gtk_table_new (NUMPHYSPARS, 3, TRUE);


  gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW (scrolledwin), 
					 twin->electrical_param_table);
  etooltips = gtk_tooltips_new ();

  for (row = 0; row < NUMPHYSPARS; row++) {
    for (col = 0; col < 3; col++) {
      switch (col) {
      case 0 :
	/* Since tooltips need to be on widgets with event capability
	 * use eventbox to locate labels and tooltips */
	labelbox = gtk_event_box_new ();
	label = gtk_label_new (tlabel->electrical_label_name[row]);
	gtk_widget_set_usize(label,10,-1);
	gtk_container_add (GTK_CONTAINER (labelbox), label);
	gtk_table_attach_defaults (GTK_TABLE (twin->electrical_param_table), 
			       labelbox, col, (col+1), row, (row+1));
	gtk_tooltips_set_tip (etooltips, labelbox, 
			      tlabel->etooltips_helptext[row], NULL);
	gtk_widget_show (label);
	gtk_widget_show (labelbox);
	break;

      case 1 :
	twin->electrical_param_text[row] = gtk_entry_new_with_max_length (10);
	switch (row) {
	case 0 :
	  defaultval = tvalue->electrical_params_value[row] * 
	    conv_res[RES_OHM][res_unit];
	  break;
	case 1 :
	  defaultval = tvalue->electrical_params_value[row] * 
	    conv_ang[ANG_DEG][ang_unit];
	  break;
	default:
	  defaultval = tvalue->electrical_params_value[row];
	  break;
	}

	sprintf(textentry,"%g", (float) defaultval);

	gtk_widget_set_usize(twin->electrical_param_text[row],10,-1);
	gtk_entry_set_text (GTK_ENTRY (twin->electrical_param_text[row]), textentry);
	gtk_table_attach_defaults (GTK_TABLE (twin->electrical_param_table), 
				   twin->electrical_param_text[row], col, (col+1), row, (row+1));
	gtk_widget_show (twin->electrical_param_text[row]);
	if (defaultval == -1.0) {
	  gtk_entry_set_text (GTK_ENTRY (twin->electrical_param_text[row]), "");
	  gtk_widget_set_sensitive ( GTK_WIDGET (GTK_ENTRY (twin->electrical_param_text[row])), FALSE);	  
	}
	break;
	
      case 2 :
	twin->electrical_param_combo[row] = GTK_WIDGET (setup_combo_widget (ELECPARAMTYPE, row));
	gtk_table_attach_defaults (GTK_TABLE (twin->electrical_param_table), 
				   twin->electrical_param_combo[row], col, (col+1), row, (row+1));
	gtk_widget_set_usize(twin->electrical_param_combo[row],4,-1);
	gtk_widget_show (twin->electrical_param_combo[row]);
	
	break;
      }
    }
  }


  free(tlabel);  
  gtk_tooltips_enable (GTK_TOOLTIPS (tooltips));
  gtk_widget_show (twin->electrical_param_table);

  gtk_widget_show (twin->electrical_param_frame);


  /* The calculated results  frame */
  free(textentry);


  if ((textentry = (char *) malloc(300*sizeof(char)))  == NULL){
    perror("results text error: malloc");
    return;
  } else {
    if (twin->results_frame == NULL) {
      strcpy(textentry,"Press Analyze to get electrical parameters\nSynthesize to derive physical parameters"); 
      statusint = INCONSISTENT;
    } else {
      strcpy (textentry,"\n");
    }
  }

  twin->results_frame = gtk_frame_new ("Calculated Results");
  gtk_container_add (GTK_CONTAINER (vbox), twin->results_frame);
  
  gtk_widget_set_usize (twin->results_frame,300,-1);

  scrolledwin = gtk_scrolled_window_new (NULL, NULL);
  gtk_container_border_width(GTK_CONTAINER(scrolledwin), 5);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwin),
                                     GTK_POLICY_AUTOMATIC,
                                     GTK_POLICY_AUTOMATIC);
  gtk_container_add (GTK_CONTAINER (twin->results_frame), 
		     scrolledwin);
  gtk_widget_show (scrolledwin);
    
  gtk_widget_set_usize (scrolledwin, -1, 150);
    
  twin->results_text = gtk_label_new (textentry);
  gtk_label_set_justify (GTK_LABEL (twin->results_text), GTK_JUSTIFY_LEFT);
  gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW (scrolledwin), 
					 twin->results_text);
  /*  gtk_container_add (GTK_CONTAINER (twin->results_frame), twin->results_text);*/
  /*  gtk_widget_set_usize (twin->results_text,-1,150);*/
  
  gtk_widget_show (twin->results_text);
  gtk_widget_show (twin->results_frame);
  
  
  gtk_widget_show (vbox);
  gtk_widget_show (hboxtop);

  hboxbot = gtk_hbox_new (FALSE, 5);
  gtk_box_pack_start (GTK_BOX (main_body_window), hboxbot, FALSE, FALSE, 0);  

  hbox3 = gtk_hbox_new (FALSE, 5);
  gtk_box_pack_start (GTK_BOX (hboxbot), hbox3, TRUE, TRUE, 0);
  setup_status (hbox3, twin);
  statusexists = TRUE;

  gtk_widget_show (hbox3);
  gtk_widget_show (hboxbot);
  gtk_widget_show (main_body_window);
  gtk_widget_show (parent);
  statusint = INCONSISTENT;

}
