/*

Copyright (C) 2001  Gopal Narayanan <gopal@astro.umass.edu>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
USA.

*/

#ifndef __RECTWAVEGUIDE_H
#define __RECTWAVEGUIDE_H

#include "transcalc.h"
#include "units.h"
#include "convert.h"


/* type = 0 substrate param
   type = 1 component param
   type = 2 physical param
   type = 3 electrical param
*/

typedef struct _rectwaveguide {
  gfloat er;               /* dielectric constant */
  gfloat mur;              /* mag. permeability */
  gfloat sigma;            /* Conductivity of the metal */
  gfloat tand;             /* Dielectric Loss Tangent */
  gfloat tanm;             /* Magnetic Loss Tangent */  
  gfloat f;                /* Frequency of operation */
  gfloat a;                /* width of waveguide */
  gfloat b;                /* height of waveguide */
  gfloat l;                /* length of waveguide */
  gfloat Z0;               /* characteristic impedance */
  gfloat ang_l;            /* Electrical length in angle */
  gfloat er_eff;           /* Effective dielectric constant */
  gfloat mur_eff;          /* Effective mag. permeability */
  gfloat atten_dielectric; /* Loss in dielectric (dB) */
  gfloat atten_cond;       /* Loss in conductors (dB) */
  gfloat skindepth;        /* Skin depth in mils */
  gfloat fc10;             /* Cutoff frequency for TE10 mode */
} rectwaveguide;

				   
gfloat kval (rectwaveguide *);
gfloat kc (rectwaveguide *, int, int);
gfloat fc (rectwaveguide *, int, int);
gfloat alphac (rectwaveguide *);
gfloat alphac_cutoff (rectwaveguide *);
gfloat alphad (rectwaveguide *);
void get_rectwaveguide_sub (trans_win *, rectwaveguide *);
void get_rectwaveguide_comp (trans_win *, rectwaveguide *);
void get_rectwaveguide_phys (trans_win *, rectwaveguide *);
void get_rectwaveguide_elec (trans_win *, rectwaveguide *);
void analyze_rectwaveguide (GtkWidget *, trans_win *);
void synthesize_rectwaveguide (GtkWidget *, trans_win *);
void fixwidth (GtkWidget *, trans_win *);
void fixheight (GtkWidget *, trans_win *);
void rectwaveguide_win (GtkWidget *);
extern void setup_transgui (int, GtkWidget *, trans_win *);


#ifndef DATADIR
#define DATADIR "."
#endif

extern void setstatus (GtkWidget *, trans_win *);

#endif


/*    GtkWidget *Er_text;        /* Er text enrty */
/*    GtkWidget *Mur_text;       /* Mur text entry */ 
/*    GtkWidget *height_text;    /* height text entry */ 
/*    GtkWidget *height_combo;   /* height combo box containing units */ 
/*    GtkWidget *topht_text;     /* top height text entry */ 
/*    GtkWidget *topht_combo;    /* top height combo box */ 
/*    GtkWidget *thickness_text; */
/*    GtkWidget *thickness_combo; */
/*    GtkWidget *cond_text; */
/*    GtkWidget *tand_text; */
/*    GtkWidget *rough_text; */
/*    GtkWidget *rough_combo; */
/*    GtkWidget *freq_text; */
/*    GtkWidget *freq_combo; */
/*    GtkWidget *width_text; */
/*    GtkWidget *width_combo; */
/*    GtkWidget *length_text; */
/*    GtkWidget *length_combo; */
/*    GtkWidget *Z0_text; */
/*    GtkWidget *Z0_combo; */
/*    GtkWidget *angle_length_text; */
/*    GtkWidget *angle_length_combo; */
