# This is a lib file containing helper functions to set
# up (and remove) the trafstats database.
# It expects whatever program called it to have sourced 
# trafstats.conf properly. YOU HAVE BEEN WARNED.


createpgdb() {
        su - postgres -c createdb $DBNAME
        RETURNVAL=$?
        if [ $RETURNVAL != 0 ]
        then
        	return $RETURNVAL
        fi
        # else
        RETURNVAL = createdbtables
        return $RETURNVAL
}

createdbtables() {
        su - postgres -c 'psql trafstats -c "CREATE TABLE rawtraffic (
        source_ip inet NOT NULL,
        source_port int4 DEFAULT 0,
        dest_ip inet NOT NULL,
        dest_port INT4 DEFAULT 0,
        timestamp TIMESTAMP NOT NULL DEFAULT TIMESTAMP(CURRENT_TIME),
        amount int8 NOT NULL
        );"'
        return $?
}

createdbwriter() {
	su - postgres -c createuser -A -D -q $DBUSER
	return $?
}

createdbidentmap() {
	cat >> /etc/postgresql/pg_ident.conf<<EOF 
#Added by trafstats installation#
$DBNAME		root	$DBWRITER
$DBNAME		root	$DBREADER
$DBNAME		postgres	postgres
#End trafstats added section# 
EOF
	RETURNVAL=$?
	if [ $RETURNVAL != 0 ]
	then
		return $RETURNVAL
	fi
	# else
	cat >> /etc/postgresql/pg_hba.conf <<EOF
#Added by trafstats installation#
local		$DBNAME				peer $DBNAME
#End trafstats added section#
EOF
	return $RETURNVAL
}

grantuser() {
	echo -n "Granting write access on rawtraffic in $DBNAME to $DBWRITER..."
	su - postgres -c 'psql $DBNAME -c "GRANT INSERT ON rawtraffic TO $DBWRITER"'
	RETVAL=$?
	if [ $RETVAL == 0 ]
	then
		echo "Done."
	else
		echo "Failed!"
		return $RETVAL
	fi
	
	echo -n "Granting read access on rawtraffic in $DBNAME to $DBREADER..."
	su - postgres -c 'psql $DBNAME -c "GRANT SELECT ON rawtraffic TO $DBREADER"'
	RETVAL=$?
	if [ $RETVAL == 0 ]
	then
		echo "Done."
	else
		echo "Failed!"
	fi
	return $RETVAL
}

removedb() {
	su - postgres -c 'psql template1 -c "DROP DATABASE $DBNAME"'
}

removeusers() { 
	echo -n "Removing reader user: $DBREADER ..."
	su - postgres -c 'psql template1 -c "DROP USER $DBREADER"'
	RETVAL=$?
	if [ $RETVAL == 0 ]
	then
		echo "Done!"
	else
		echo "Failed!"
		return $RETVAL
	fi
	
	echo -n "Removing writer user: $DBWRITER ..."
	su - postgres -c 'psql template1 -c "DROP USER $DBWRITER"'
	if [ $RETVAL == 0 ]
	then
		echo "Done!"
	else
		echo "Failed!"
		return $RETVAL
	fi
}

