import os
from os import path
from shutil import rmtree
from tempfile import mkdtemp

from bzrlib import bzrdir, tests

from tracbzr import backend

class MultiBranchTracTestCase(tests.TestCase):
    def setUp(self):
        self.root = mkdtemp(prefix='trac+bzr-')
        self.old_cwd = os.getcwd()
        os.chdir(self.root)
        self.repo_root = path.join(self.root, 'repo')
        os.mkdir(self.repo_root)
        dir = bzrdir.BzrDir.create(self.repo_root)
        self.repo = dir.create_repository()
        self.treedir = path.join(self.repo_root, 'tree')
        self.branch = bzrdir.BzrDir.create_branch_convenience(self.treedir,
            force_new_tree=True)
        self.tree = self.branch.bzrdir.open_workingtree()

    def trac_repo(self):
        return backend.BzrRepository(self.repo_root, None)

    def tearDown(self):
        os.chdir(self.old_cwd)
        rmtree(self.root)


class SingleBranchTracTestCase(tests.TestCase):
    def setUp(self):
        self.root = mkdtemp(prefix='trac+bzr-')
        self.old_cwd = os.getcwd()
        os.chdir(self.root)
        branch = bzrdir.BzrDir.create_branch_convenience(self.root, 
                        force_new_tree=True)
        self.tree = branch.bzrdir.open_workingtree()
        self.repo = branch.repository
        self.treedir = self.root

    def trac_repo(self):
        return backend.BzrRepository(self.root, None)

    def tearDown(self):
        os.chdir(self.old_cwd)
        rmtree(self.root)
