.de EX
.ift .ft 5
.nf
..
.de EE
.ft1
.fi
..
.TH TRA 1
.SH NAME
minisync, tramkdb, trascan, trasrv, trafixdb \- unidirectional replica synchronization
.SH SYNOPSIS
.B minisync
[
.B -Anftv
]
[
.B -z
.I n
]
.I src
.I dst
[
.I paths
...
]
.PP
.B trascan
.I replica
[
.I paths
...
]
.PP
.B tramkdb
.I dbfile
.I replicaname
.PP
.B trasrv
[
.B -i
.I ifile
]
[
.B -o
.I option
]
.I dbfile
.I root
.PP
.B trafixdb
.B -l
.PP
.B trafixdb
[
.B -n
]
.I dbfile
[
.I outdbfile
]
.SH DESCRIPTION
Tra is a
file system synchronizer.
It helps to manage the replication of a shared
file system on many hosts, automatically
propagating updates when possible.
The file system is
.I optimistically
.IR replicated :
any replica is allowed to make any change at any time.
Changes are propagated via pairwise synchronization
between replicas.
Incomptible changes, called conflicts, are reported
to the user for manual resolution.
.SS Minisync
.PP
.I Minisync
tracks the modification history of each file as it is changed and copied
from replica to replica.
The replica names on the command line are executable files,
typically shell scripts,
that run
.I trasrv
with appropriate arguments.
Replica names are further described a few paragraphs later in this section.
.PP
The synchronization of a single file proceeds as follows
(this is a description of the behavior, not the implementation):
.RS
.IP 1.
If the history of the file on
.I src
is a prefix of or equal to the history on
.IR dst ,
then
.I dst
is up-to-date; do nothing.
.IP 2.
If the history of the file on
.I dst
is a prefix of the history of the file on 
.IR src ,
the file on
.I src
is propagated to
.IR dst .
.IP 3.
If neither history is a prefix of the other,
the two files have diverged.  Report a conflict.
.RE
Creation or deletion of a file is considered an event in the
history of a file.
Conflict names take the form
.IR action / action ,
indicating how the histories have diverged;
the first
.I action
corresponds to the file on
.I src
and the second
.I action
corresponds to the file on
.IR dst .
.I Action
is one of
.BR update ,
.BR create ,
or
.BR delete .
For example, an
.B update/delete
conflict indicates that since the files on
.I src
and
.I dst
diverged, the file on
.I src
has been updated but the file on
.I dst
has been deleted.
Of course, these changes might have occurred on other replicas
and propagated to
.I src
and
.IR dst .
.PP
.I Minisync
performs a undirectional synchronization,
propagating updates from the replica
.I src
to the replica
.I dst.
If
.I paths
are specified, the synchronization is limited
to files and directories in the trees rooted at those paths.
If no
.I path
is specified, the entire replica is synchronized.
.PP
The options are:
.TP
.B -A
By default, when two identical files are in conflict,
the conflict is automatically resolved.
The
.B -A
flag turns this auto-resolution off.
.TP
.B -n
Do nothing.  Print what would be done.
.TP
.B -f
Resolve all conflicts in favor of the
.I src
(from)
replica.
.TP
.B -t
Resolve all conflicts in favor of the
.I dst
(to)
replica.
.TP
.B -v
Verbose; print file system operations as they are carried out.
.TP
.B -z
Set deflate compression level, from 1 to 9.
.PD
.PP
The arguments
.I src
and
.I dst
are named by executables that establish
connections to
.IR trasrv (8).
If a replica name does not begin with
.BR ./ ,
.BR ../ ,
or
.BR / ,
it is prefixed with the path
.B $home/lib/tra
(on Plan 9) or
.B $HOME/.tra
(on Unix).
.PP
If the file
.B $home/lib/tra/minisync.log
(on Plan 9)
or
.B $HOME/.tra/minisync.log
(on Unix)
exists,
.I minisync
appends a log of its actions to the file.
.SS Tramkdb
File histories are kept in an on-disk database.
.I Tramkdb
initializes a new database.
The bulk of the data is kept in
.IR dbfile ,
which typically has a
.B .tradb
suffix.
Auxiliary files
.IB dbfile .redo
and
.IB dbfile .redo2
hold block-level and database operation-level redo logs.
Each replica has a name that is used in the internal metadata
and in the explanations of conflicts.
This is the second argument to
.I tramkdb
and stored in the database.
So that replicas can't accidentally be configured with
identical names, the given
.I replicaname
is suffixed with a random 32-bit number.
.SS Trascan
.PP
.I Trascan
performs a file system scan of the named paths on
.I replica
(an executable interpreted exactly as
.IR minisync 's
.I src
and
.I dst
arguments)
and updates the database, but does not
touch the file system.
.PP
In order to detect updates reliably, the database includes
SHA1 hashes of every file in the file system.
The first file system scan for a newly created replica can
take a long time, since all the data in the file system must be hashed.
.I Trascan
is a useful way to initialize the database without
performing any file system operations.
.SS Trasrv
.I Trasrv
is the per-replica server to which
.I minisync
connects.
It needs to be told the database to use
and the root of the replicated file system.
The
.B -i
option instructs
.I trasrv
to consult
.I ifile
for a list of paths to include or exclude
from replication.
In the
.IR ifile ,
blank lines and lines beginning with a sharp
.RB ( # )
are ignored.
The other lines must be of the form
.I verb
.IR pattern ,
where
.I verb
is
.B include
or
.B exclude
and
.I pattern
is a shell-style file name pattern.
To decide whether to include a given path,
each line in the file is consulted in order; the earliest pattern
that matches determines whether the path is included.
If no pattern matches, the path is included.
If no
.B -i
option is given, a default rule set is used:
.EX
	# default rule set for trasrv
	exclude *.tradb*
	exclude minisync.log
.EE
If the pattern is rooted, as in
.BR /a/b ,
then the pattern must match the entire path.
If the pattern is not rooted, as in
.B *.tradb*
or
.BR a/b ,
then the pattern need only match the end of the path.
.PP
The
.B -o
flag enables
.I option ,
which is an arbitrary string.
The collection of options includes:
.TP
.B setmode
Include file mode information in synchronizations.
This causes changes to file modes to be propagated to
other replicas that have enabled the
.B setmode
option.
.TP
.B setuid
Include file owner information in synchronizations.
.TP
.B setgid
Include file group information in synchronizations.
.TP
.B setmtime
Include file modification time information in synchronizations.
.TP
.B mkwriteable
Make read-only files temporarily writeable for the purposes
of update propagation.
This is useful primarily for propagating RCS files.
.TP
.B testdblog
Do not flush the database to disk when 
.I trasrv
has finished.  This is used to exercise the
.I redo2
database operation log.
.SS Trafixdb
.I Trafixdb
is the Tra database
equivalent of the Unix utility
.IR fsck :
it scans for inconsistencies and fixes them,
reporting the changes it makes.
Unlike in some Unix file systems, 
inconsistencies can not arise from surprise interruptions
(e.g., killing a running
.IR trasrv ).
Updates to the database are performed atomically,
so the only source of inconsistencies is
programmer error.
.I Trafixdb
is updated when such errors are found and fixed in the 
actual database code.
The command
.EX
	trafixdb -l
.EE
displays a list of errors that
.I trafixdb
can repair, along with the date the bug was fixed in the database code.
.PD
.SH EXAMPLES
This example demonstrates setting up replicas and running 
a simple synchronization.
.EX
	$ cd /tmp
	$ mkdir r1 r2
	$ cat >t1 <<!
	#!/bin/sh
	trasrv t1.tradb /tmp/r1
	!
	$ cat >t2 <<!
	#!/bin/sh
	trasrv -r t2.tradb /tmp/r2
	!
	$ chmod +x t1 t2
	$ tramkdb t1.tradb repl1
	$ tramkdb t2.tradb repl2
	$ echo hello world >r1/a
	$ minisync -v ./t1 ./t2
	copy /a
	$ cat r2/a
	hello world
	$ 
.EE
.PP
A more full featured replica might be
.EX
	g% cat lib/tra/emelie
	#!/bin/rc
	trasrv -o setmode -o setgid /usr/rsc/lib/tra/emelie.tradb /usr/rsc
	g%
.EE
Notice that files on remote machines may be replicated
by running
.I trasrv
on a remote machine in the shell script.
For example,
.EX
	g% cat .tra/wally
	#!/bin/sh
	ssh wally trasrv $HOME/.tra/xxx.tradb $HOME
	g% 
.EE
This is actually oversimplified:
when using remote connections, in order to convince
.I ssh
to turn off Nagle's algorithm (which slows down our RPCs
considerably), use
.EX
	ssh -2 -q -e none -t -t 
.EE
on Unix
or
.EX
	ssh -Rmp
.EE
on Plan 9.
This has the side effect of causing
.I ssh
to allocate a pty for the connection,
which merges standard output and standard error.
Since
.B trasrv
occasionally writes important information on standard
error, it is a good idea to use the programs
.I stdmerge
and
.I stdsplit
(see
.IR tra-aux (1))
to keep them separate.
A full example would then be:
.EX
	g% cat .tra/wally
	#!/bin/sh
	ssh -2 -q -e none -t -t wally stdmerge trasrv \e
		$HOME $HOME/.tra/xxx.tradb | stdsplit
	g% 
.EE
.SH SOURCE
.B
cvs -d :pserver:anoncvs@cvs.pdos.lcs.mit.edu:/cvs co tra
.SH TRACES
We are interested in collecting traces of synchronization
activity for research purposes.
We would greatly appreciate it if you turn on logging
(by creating
or
.B $home/lib/tra/minisync.log
on Plan 9
or
.B $HOME/.tra/minisync.log
on Unix)
and mail us your log file occasionally (for example, when
the size starts to bother you, you might mail it and then
zero it.  Please compress the logs before sending.
For example:
.EX
	# plan 9
	g% gzip < lib/tra/minisync.log >/tmp/a
	g% echo minisync logs | mail -a /tmp/a tralog@pdos.lcs.mit.edu
	g% 
	# unix
	$ gzip < .tra/minisync.log |
	  uuencode minisync.log.gz |
	  mail tralog@pdos.lcs.mit.edu
	$
.EE
.PP
The log contains the dates and times of your synchronizations,
the names of the files being synchronized, the names of the
machines involved, and the
.I minisync
command lines.
We promise not to make the logs available to others without
first appropriately anonymizing them.
