#include "tra.h"

static void
tramp(int a0, int a1, int a2, int a3, int a4, int a5,
      void (*fn)(void*), void *arg)
{
	USED(a0); USED(a1); USED(a2);
	USED(a3); USED(a4); USED(a5);
	fn(arg);
	abort();
}

/* sparc v8 initctxt */
void
initctxt(Ctxt *c, void (*fn)(void*), void *arg)
{
	int n;
	ulong *stk;
	Label *l;

	l = &c->label;
	n = 28*sizeof(u32int);
	c->stk = emalloc(n);
	stk = (ulong*)((uchar*)c->stk + n);
	--stk;
	--stk;
	--stk;
	*--stk = (ulong)arg;
	*--stk = (ulong)fn;
	l->pc = (ulong)tramp+LABELDPC;
	l->sp = mainlabel.sp - n;
	l->fp = mainlabel.sp;
}
