/*
	v0		--> $0		return value
	t0-t7		--> $1-$8	caller saved (temporary)
	s0-s6		--> $9-$15	callee saved
	a0-a5		--> $16-$21	caller saved (argument)
	t8-t11		--> $22-$25	caller saved (temporary)
	ra		--> $26		return address
	t12/pv		--> $27		procedure value
	at		--> $28		assembler scratch
	gp		--> $29		global pointer
	sp		--> $30		stack pointer
			--> $31		wired zero
	fv0		--> $f0		return value (real)
	fv1/ft0		--> $f1		return value (imaginary)
	fs0-fs7		--> $f3-$f9	callee saved
	ft1-ft6		--> $f10-$f15	caller saved (temporary)
	fa0-fa5		--> $f16-$f21	caller saved (argument)
	ft7-ft15	--> $f22-$f30	caller saved (temporary)
			--> $f31	wired zero
*/

#define v0	$0

#define t0	$1
#define t1	$2
#define t2	$3
#define t3	$4
#define t4	$5
#define t5	$6
#define t6	$7
#define t7	$8

#define s0	$9
#define s1	$10
#define s2	$11
#define s3	$12
#define s4	$13
#define s5	$14
#define s6	$15
#define fp	$15	/* fp & s6 are the same	*/

#define a0	$16
#define a1	$17
#define a2	$18
#define a3	$19
#define a4	$20
#define a5	$21

#define t8	$22
#define t9	$23
#define t10	$24
#define t11	$25

#define ra	$26

#define pv	$27	/* pv and t5 are the same */
#define t12	$27

#define AT	$at

#define gp	$29

#define	sp	$30
#define zero	$31

#define	fv0	$f0	/* (T)		return value (real)	*/
#define	fv1	$f1	/* (T)		return value (imaginary)*/
#define	ft0	fv1
#define	fs0	$f2	/* (S)		call-safe registers	*/
#define	fs1	$f3
#define	fs2	$f4
#define	fs3	$f5
#define	fs4	$f6
#define	fs5	$f7
#define	fs6	$f8
#define	fs7	$f9
#define	ft1	$f10	/* (T)		temporary registers	*/
#define	ft2	$f11
#define	ft3	$f12
#define	ft4	$f13
#define	ft5	$f14
#define	ft6	$f15
#define	fa0	$f16	/* (T)		argument registers	*/
#define	fa1	$f17
#define	fa2	$f18
#define	fa3	$f19
#define	fa4	$f20
#define	fa5	$f21
#define	ft7	$f22	/* (T)		more temporaries	*/
#define	ft8	$f23
#define	ft9	$f24
#define	ft10	$f25
#define	ft11	$f26
#define	ft12	$f27
#define	ft13	$f28
#define	ft14	$f29
#define	ft15	$f30
#define	fzero	$f31	/*		wired zero		*/
