typedef struct Chan Chan;
typedef struct Ctxt Ctxt;
typedef struct Fdbuf Fdbuf;
typedef struct Fdmsg Fdmsg;
typedef struct Thread Thread;

struct Ctxt
{
	Label label;	/* label should be (d)word aligned */
	void *stk;
};

struct Fdbuf
{
	Lock lk;
	int fd;
	int dead;
	Fdmsg *m;
	Fdmsg **em;
	Thread *t;
};

Chan*	_chan(int);
#define	chan(T)	_chan(sizeof(*(T*)0))
void		closefdbuf(Fdbuf*);
void	gotolabel(Label*);
Fdbuf*	openfdbuf(int);
void	_fdbufwatch(Fdbuf*);
void		initctxt(Ctxt*, void(*)(void*), void*);
int		readfdbuf(Fdbuf*, void*, int);
int		readnfdbuf(Fdbuf*, void*, int);
void		recv(Chan*, void*);
void*	recvp(Chan*);
ulong	recvul(Chan*);
void		send(Chan*, void*);
void		sendp(Chan*, void*);
void		sendul(Chan*, ulong);
int	setlabel(Label*);
void		threadcreate(void(*)(void*), void*);
void**	threaddata(void);
void		threadexit(void);
void		threadready(Thread*);
void		threadsleep(void);
void		yield(void);

extern	Thread*	curthread;
extern	Label	mainlabel;

