// Copyright (C) 2002 Zbigniew Leyk (zbigniew.leyk@anu.edu.au)
//                and David E. Stewart (david.stewart@anu.edu.au)
//                and Ronan Collobert (collober@iro.umontreal.ca)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef MX_LOW_LEVEL_INC
#define MX_LOW_LEVEL_INC

#include "general.h"

namespace Torch {
#define VUNROLL

/*  Collection of low level functions.
    Based on the "Meschach Library", available at the
    anonymous ftp site thrain.anu.edu.au in the directory
    pub/meschach.

    @author David E. Stewart (david.stewart@anu.edu.au)
    @author Zbigniew Leyk (zbigniew.leyk@anu.edu.au)
    @author Ronan Collobert (collober@iro.umontreal.ca)
*/

// Inner product
real mxIp__(real * dp1, real * dp2, int len);
// Scalar multiply and add c.f. v_mltadd()
void mxRealMulAdd__(real * dp1, real * dp2, real s, int len);
// Scalar multiply array c.f. sv_mlt()
void mxRealMul__(real * dp, real s, real * out, int len);
// Add arrays c.f. v_add()
void mxAdd__(real * dp1, real * dp2, real * out, int len);
// Subtract arrays c.f. v_sub()
void mxSub__(real * dp1, real * dp2, real * out, int len);
// Zeros an array of floating point numbers
void mxZero__(real * dp, int len);


}

#endif
