// Copyright (C) 2002 Ronan Collobert (collober@iro.umontreal.ca)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef WEIGHTED_MSE_CRITERION_INC
#define WEIGHTED_MSE_CRITERION_INC

#include "Criterion.h"

namespace Torch {

/** Similar to #MseCriterion#, but you
    can put a weight on each example.

    @author Ronan Collobert (collober@iro.umontreal.ca)
*/
class WeightedMseCriterion : public Criterion
{
  public:

    /** Pointer on the weights.
        You can modify the weights when you want.
        
        The length of #weights# \emph{is} the
        #n_real_examples# of #data#.
    */
    real *weights;
    bool weights_is_allocated;

    //-----

    /** With this constructor, the weights are allocated
        and initializated to 1.
    */
    WeightedMseCriterion(DataSet *data_);

    /** With this constructor, you provide the #weights#.

       The length of #weights# \emph{must be} the
       #n_real_examples# of #data#.       
    */
    WeightedMseCriterion(DataSet *data_, real *weights_);

    //-----

    virtual void setDataSet(DataSet *data_);
    virtual void allocateMemory();
    virtual void freeMemory();
    virtual void forward(List *inputs);
    virtual void backward(List *inputs, real *alpha);
    virtual ~WeightedMseCriterion();
};


}

#endif
