// Copyright (C) 2002 Ronan Collobert (collober@iro.umontreal.ca)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "Tanh.h"

namespace Torch {

Tanh::Tanh(int n_units)
{
  n_inputs = n_units;
  n_outputs = n_units;
}

int Tanh::numberOfParams()
{
  return(0);
}

void Tanh::forward(List *inputs)
{
  real *ptr_out = (real *)outputs->ptr;
  while(inputs)
  {
    real *x = (real *)inputs->ptr;
    for(int j = 0; j < inputs->n; j++)
      *ptr_out++ = tanh(*x++);
    inputs = inputs->next;
  }
}

void Tanh::backward(List *inputs, real *alpha)
{
  real *alpha_ptr = alpha;
  real *beta_ptr = beta;
  real *out_ptr = (real *)outputs->ptr;
  for(int i = 0; i < n_outputs; i++)
  {
    real z = *out_ptr++;
    *beta_ptr++ = *alpha_ptr++ * (1. - z*z);
  }
}

Tanh::~Tanh()
{
}

}

