// Copyright (C) 2002 Ronan Collobert (collober@iro.umontreal.ca)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef MULTI_CLASS_FORMAT_INC
#define MULTI_CLASS_FORMAT_INC

#include "ClassFormat.h"
#include "DataSet.h"

namespace Torch {

/** Define the multi class code.
    Each class is coded by a single number.

    @author Ronan Collobert (collober@iro.umontreal.ca)
*/
class MultiClassFormat : public ClassFormat
{
  public:

    /// Table of class labels
    real *tabclasses;

    /// Autodetect classes
    MultiClassFormat(DataSet *data);

    /// By default, class labels are 0, 1, ...
    MultiClassFormat(int n_classes_, real *class_labels_=NULL);

    virtual int getTargetClass(void *target);
    virtual int getOutputClass(List *outputs);

    virtual int getOutputSize();
    virtual void fromOneHot(List *outputs, List *one_hot_outputs);
    virtual void toOneHot(List *outputs, List *one_hot_outputs);

    virtual ~MultiClassFormat();
};


}

#endif
