// Copyright (C) 2002 Ronan Collobert (collober@iro.umontreal.ca)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "MseCriterion.h"

namespace Torch {

MseCriterion::MseCriterion(int n_inputs_)
{
  n_inputs = n_inputs_;
}


void MseCriterion::forward(List *inputs)
{
  real *desired = (real *)data->targets;
  real err = 0;
  while(inputs)
  {
    real *x = (real *)inputs->ptr;
    for(int j = 0; j < inputs->n; j++)
    {
      real z = *desired++ - *x++;
      err += z*z;
    }
    inputs = inputs->next;
  }

  real *ptr_out = (real *)outputs->ptr;
  ptr_out[0] = err;
}

void MseCriterion::backward(List *inputs, real *alpha)
{
  real *desired = (real *)data->targets;
  real *ptr_beta = beta;
  while(inputs)
  {
    real *x = (real *)inputs->ptr;
    for(int j = 0; j < inputs->n; j++)
      *ptr_beta++ = 2.*(*x++ - *desired++);
    inputs = inputs->next;
  }
}

MseCriterion::~MseCriterion()
{
}

}

