// Copyright (C) 2002 Ronan Collobert (collober@iro.umontreal.ca)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "List.h"
#include "general.h"

namespace Torch {

void addToList(List **x_, List *y)
{
  List *x = *x_;
  bool kim = true;

  if(!y)
    return;

  if(!x)
  {
    x = (List *)xalloc(sizeof(List));
    x->next = NULL;
    *x_ = x;
    kim = false;
  }
  else
  {
    while(x->next)
      x = x->next;
  }

  while(y)
  {
    if(kim)
    {
      x->next = (List *)xalloc(sizeof(List));
      x = x->next;
    }
    else
      kim = true;

    x->n = y->n;
    x->ptr = y->ptr;
    x->next = NULL;
    y = y->next;
  }
}

void addToList(List **x_, int n, void *ptr)
{
  List *x = *x_;
  bool kim = true;

  if(!x)
  {
    x = (List *)xalloc(sizeof(List));
    x->next = NULL;
    *x_ = x;
    kim = false;
  }
  else
  {
    while(x->next)
      x = x->next;
  }

  if(kim)
  {
    x->next = (List *)xalloc(sizeof(List));
    x = x->next;
  }
  
  x->n = n;
  x->ptr = ptr;
  x->next = NULL;
}

void freeList(List **x_, bool free_ptrs)
{
  List *x = *x_;
  List *y;

  while(x)
  {
    y = x->next;
    if(free_ptrs)
      free(x->ptr);
    free(x);
    x = y;
  }

  *x_ = NULL;
}

void copyList(List* to, List* from)
{
  real* from_ptr = (real*)from->ptr;
  int index_from = 0;

  while(to)
  { 
    real* to_ptr = (real*)to->ptr;
    for(int i = 0; i < to->n; i++)
    {
      if(index_from == from->n)
      {
        from = from->next;
        from_ptr = (real*)from->ptr;
        index_from = 0;
      }
      *to_ptr++ = *from_ptr++;
      index_from++;
    }
    to = to->next;
  }
}

void copyList(real* to, List* from)
{
  while(from)
  {
    real* from_ptr = (real*)from->ptr;
    for(int i = 0; i < from->n; i++)
      *to++ = *from_ptr++;
    from = from->next;
  }
}

}

