// Copyright (C) 2002 Ronan Collobert (collober@iro.umontreal.ca)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef LINEAR_INC
#define LINEAR_INC

#include "GradientMachine.h"

namespace Torch {

/** Linear layer for #GradientMachine#.
    Formally speaking, $ouputs[i] = \sum_j w_{ij} inputs[i] + b_i$.\\
    $w_{ij}$ and $b_j$ are in #params#, with the following structure:\\
    $w_00... w_0n, b_0, w_10... w_1n, b_1, ...$\\

    If you want, you can add a weight decay which looks like
    $\sum_i,j w_{ij}^2 + sum_i b_i^2$.

    Options:
    \begin{tabular}{lcll}
      "weight decay"  &  real  &  the weight decay & [0]
    \end{tabular}

    @author Ronan Collobert (collober@iro.umontreal.ca)
*/
class Linear : public GradientMachine
{
  public:
    real weight_decay;

    //-----

    ///
    Linear(int n_inputs_, int n_outputs_);

    //-----

    virtual int numberOfParams();
    virtual void init();
    virtual void reset();
    virtual void forward(List *inputs);
    virtual void backward(List *inputs, real *alpha);
    virtual ~Linear();
};


}

#endif
