// Copyright (C) 2002 Ronan Collobert (collober@iro.umontreal.ca)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef BOOSTING_INC
#define BOOSTING_INC

#include "Trainer.h"
#include "WeightedSumMachine.h"
#include "ClassFormat.h"

namespace Torch {

/** Boosting implementation.
    As the idea of boosting in regression hasn't been really well tested,
    this is boosting for *classification* only.
    
    This trainer will "boost" the machine given by the #WeightedSumMachine#,
    on the given #DataSet#.

    You have to provide a #ClassFormat# to know how the classes are encoded.

    @author Ronan Collobert (collober@iro.umontreal.ca)
    @see WeightedSumMachine
*/
class Boosting : public Trainer
{
  public:

    /// This machine performs the combination. It contains many trainers.
    WeightedSumMachine *w_machine;

    /// #ClassFormat# to know how the classes are encoded.
    ClassFormat *class_format;

    /// The number of trainers in the boosting.
    int n_trainers;

    /// The weights of each machine in the boosting.
    real *weights;

    ///
    Boosting(WeightedSumMachine *w_machine_, DataSet* data_, ClassFormat *class_format_);

    //-----

    virtual void train(List *measurers);

    virtual ~Boosting();
};


}

#endif
