// Copyright (C) 2002 Samy Bengio (bengio@idiap.ch)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef BAGGING_INC
#define BAGGING_INC

#include "Trainer.h"
#include "Measurer.h"
#include "DataSet.h"
#include "WeightedSumMachine.h"

namespace Torch {

/** This class represents a #Trainer# that implements the well-known
    Bagging algorithm (Breiman, 1996). A "bagger" contains a series
    of trainers, each trained on a bootstrap of the original dataset.
    The output of the bagging is then the average of the output of
    each trainer.

    It is implemented using a #WeightedSumMachine# that performs the combination.

    @author Samy Bengio (bengio@idiap.ch)
    @see WeightedSumMachine
*/
class Bagging : public Trainer
{
  public:

    /// This machine performs the combination. It contains many trainers.
    WeightedSumMachine* w_machine;

    /// The number of trainers in the bagging.
    int n_trainers;

    /// for each trainer, keep the indices of examples not used during training
    int** unselected_examples;
    /// for each trainer, keep the indices of examples used during training
    int** selected_examples;
    /// for each trainer, keep the number of examples not used during training
    int* n_unselected_examples;
    /// for each trainer, keep the number of examples used during training
    int* is_selected_examples;
 
    ///
    Bagging(WeightedSumMachine *w_machine_, DataSet* data_);

    /// create a boostrap of the data and put in in selected
    virtual void bootstrapData(int* selected, int* is_selected);

    virtual void train(List *measurers);

    virtual ~Bagging();
};


}

#endif
