// Copyright (C) 2002 Samy Bengio (bengio@idiap.ch)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef VITERBI_TRAINER_INC
#define VITERBI_TRAINER_INC

#include "EMTrainer.h"

namespace Torch {

/** This class is used to train any distribution using the Viterbi algorithm.
    This means that it is most useful for distributions over sequences,
    such as HMMs.
     
    @author Samy Bengio (bengio@idiap.ch)
*/

class ViterbiTrainer : public EMTrainer
{
  public:
    
    /// creates a Viterbi trainer given a distribution and a dataset
    ViterbiTrainer(Distribution *distribution_, SeqDataSet *data_);

    virtual void train(List *measurers);
    virtual void test(List *measurers);

    virtual ~ViterbiTrainer();
};


}

#endif
