// Copyright (C) 2002 Samy Bengio (bengio@idiap.ch)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef NLL_MEASURER_INC
#define NLL_MEASURER_INC

#include "Measurer.h"
#include "SeqDataSet.h"

namespace Torch {

/** This class measures the negative log likelihood. In fact, it supposes
    that the input given is already the negative log likelihood. It is
    then normalized by the total number of frames.

    @author Samy Bengio (bengio@idiap.ch)
*/
class NllMeasurer : public Measurer
{
  public:
    /// contains the average negative log likelihood
    real *erreur;
    /// contains the total negative log likelihood
    real *erreur_c;
    /// contains a pointer to the negative log likelihood to measure
    List *inputs;
    /// local counter of the total number of frames
    int tot_n_frames;
    /// local pointer to the dataset, used to count the number of frames
    SeqDataSet *sdata;

    ///
    NllMeasurer(List *inputs_, SeqDataSet* data_, FILE *file_);
    ///
    NllMeasurer(List *inputs_, SeqDataSet* data_, const char *filename);

    virtual void init();
    virtual void reset();
    virtual void measureEx();
    virtual void measureIter();

    virtual ~NllMeasurer();
};


}

#endif
