// Copyright (C) 2002 Samy Bengio (bengio@idiap.ch)
//                and Bison Ravi (francois.belisle@idiap.ch)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef BAYES_CLASSIFIER_INC
#define BAYES_CLASSIFIER_INC


#include "Trainer.h"
#include "BayesClassifierMachine.h"

namespace Torch {

/** A multi class bayes classifier -- maximizes the likelihood of each class
    separately using a trainer for distribution. When testing, the predicted 
    class corresponds to the trainer giving the maximum output, weighted by
    its prior probability.
 
    @author Samy Bengio (bengio@idiap.ch)
    @author Bison Ravi (francois.belisle@idiap.ch)
*/
class BayesClassifier : public Trainer
{
  public:
    
    /// the bayes machine
    BayesClassifierMachine* bayesmachine; 
    
    /// the number of different classes
    int n_classes;
    
    /// all the example indices of each class.
    int** classes; 
    ///the number of examples per class.
    int* classes_n; 

    /// you need to define a BayesClassifierMachine to use this class
    BayesClassifier( BayesClassifierMachine* , DataSet*);
    virtual ~BayesClassifier();

    virtual void train( List* );

};


}

#endif
