// Copyright (C) 2002 Samy Bengio (bengio@idiap.ch)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef RBF_INC
#define RBF_INC

#include "ConnectedMachine.h"
#include "Linear.h"
#include "Exp.h"
#include "Tanh.h"
#include "LogRBF.h"
#include "SumMachine.h"

namespace Torch {

/** This class is a simple interface to the #ConnectedMachine# class that
    ca be used to build the well-known Radial Basis Function type of
    neural networks. It contains a layer of #LogRBF# followed by a layer
    of #Exp#, followed by a layer of #Linear# and optionally a layer
    of #Tanh# for classification experiments. Optionally, it also contains
    a direct connection from the inputs to the linear layer.

    @author Samy Bengio (bengio@idiap.ch)
*/
class RBF : public ConnectedMachine
{
  public:
    /// the #LogRBF# layer
    LogRBF *log_rbf_layer;
    /// the #Exp# layer
    Exp *exp_layer;
    /// the #Linear# layer
    Linear *outputs_layer;
    /// the optional #Tanh# layer
    Tanh *outputs_tanh_layer;
    /// the number of basis functions
    int n_hidden;
    /// if this is false, add a #Tanh# layer
    bool is_linear_outputs;
    /// if this is true, add a direct connection from inputs to #Linear#
    bool inputs_to_outputs;
    /// the direct #Linear# layer
    Linear* add_layer;
    /// if #inputs_to_outputs# is true, we also need a #SumMachine#
    SumMachine* sum_layer;

    ///
    RBF(int n_inputs_, int n_hidden, int n_outputs_, bool is_linear_outputs_=true,bool inputs_to_outputs=false,EMTrainer* kmeans_trainer=NULL);
    virtual ~RBF();
};


}

#endif
