// Copyright (C) 2002 Samy Bengio (bengio@idiap.ch)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "ParzenMachine.h"

namespace Torch {

ParzenMachine::ParzenMachine(DataSet* data_,real var_)
{
  data = data_;
  setVar(var_);
  n_outputs = data->n_targets;
  n_inputs = data->n_inputs;
  addToList(&outputs, n_outputs, (real *)xalloc(sizeof(real)*n_outputs));
  n_real_examples = 0;
  real_examples = NULL;
}

void ParzenMachine::setVar(real var_)
{
  var = var_;
}

void ParzenMachine::reset()
{
  data->setExample(0);
  n_real_examples = data->n_examples;
  real_examples = (int*)xrealloc(real_examples,n_real_examples*sizeof(int));
  for (int i=0;i<data->n_examples;i++) {
    real_examples[i] = data->selected_examples[i];
  }
}

void ParzenMachine::forward(List* inputs)
{
  // keep current example in order to restore at the end
  int current_example = data->current_example;

  real* out = (real*)outputs->ptr;
  denominator = 0.;
  for (int j=0;j<n_outputs;j++)
    *out++ = 0;
  int *i_ptr = real_examples;
  for (int i=0;i<n_real_examples;i++) {
    data->setRealExample(*i_ptr++);
    real* in = (real*)inputs->ptr;
    real* in_i = (real*)data->inputs->ptr;
    real dist = 0;
    for (int j=0;j<n_inputs;j++) {
      real z = *in++ - *in_i++;
      dist += z*z;
    }
    real e = exp(-dist / (2.*var));
    denominator += e;
    out = (real*)outputs->ptr;
    real* targ_i = (real*)data->targets;
    for (int j=0;j<n_outputs;j++) {
      *out++ += *targ_i++ * e;
    }
  }

  out = (real*)outputs->ptr;
  for (int j=0;j<n_outputs;j++)
    *out++ /= denominator;

  // restore current_example
  data->setRealExample(current_example);
}

ParzenMachine::~ParzenMachine()
{
  freeList(&outputs,true);
  free(real_examples);
}

}

