// Copyright (C) 2002 Samy Bengio (bengio@idiap.ch)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef OUTPUT_MEASURER_INC
#define OUTPUT_MEASURER_INC

#include "Measurer.h"
#include "Machine.h"
#include "DataSet.h"

namespace Torch {

/** This class can be used to save the outputs of a #Trainer# 
    in a file in such a format that it can be read again in #Torch# using the
    #FileDataSet# class. Optionally, it also prints the corresponding inputs
    and/or the corresponding targets.

    @author Samy Bengio (bengio@idiap.ch)
*/
class OutputMeasurer : public Measurer
{
  public:
    /// the pointer the obtained outputs
    List *inputs;
    /// a boolean stating whether we also print the corresponding inputs
    bool print_inputs;
    /// a boolean stating whether we also print the corresponding targets
    bool print_targets;

    ///
    OutputMeasurer(List *inputs_, DataSet *data_, FILE *file_, bool print_inputs_=false,bool print_targets=true);
    ///
    OutputMeasurer(List *inputs_, DataSet *data_, const char *filename, bool print_inputs_=false,bool print_targets=true);

    virtual void init();
    virtual void reset();
    virtual void measureEx();
    virtual void measureIter();

    virtual ~OutputMeasurer();
};


}

#endif
