# This specfile is Mandrake Linux specific
#
# This requires a working Oracle installation to build with a set ORACLE_HOME
# environment. Requires at least version 8.1.7 of Oracle.
#


%define _name		tora

%define _version	1.3.23
%define _release	1
%define _prefix		/usr/X11R6

# preferred something like this
#%define __find_requires  /usr/lib/rpm/find-requires | grep -v libclntsh

# For the moment
%define __find_requires %{nil}


Summary:		Toolkit for Oracle
Name:			%{_name}
Version:		%{_version}
Release:		%{_release}
Source:			%{_name}-%{_version}.tar.gz
URL:			http://tora.sourceforge.net
Group:			Development/Databases
Packager:		Raj Thukral (thukral at pobox dot com)
License:		GPL
BuildRoot:		%{_tmppath}/tora-root
Prefix:			%{_prefix}


#
# Description below is copied verbatim from the README file
#

%description


TOra - Toolkit for Oracle
=========================
Copyright (C) 2003-2005 Quest Software, Inc (http://www.quest.com/)
Portions Copyright (C) 2005 Other Contributors

For information about license see the LICENSE.txt file. It is distributed 
under the GPL which basically means that any derivatory work must be 
released under an open source license as well.

TOra is supported for running with an Oracle 8.1.7 or newer
client installation. It has been verified to work with Oracle 10g.

In addition, TOra also supports postgres and mysql if your Qt library
is compiled with that support.

Toolkit for Oracle is a program for Oracle developers and administrators. The
features that are available so far is (As of version 1.2):

* Handles multiple connections
* Support Oracle & MySQL
* Advanced SQL Worksheet
	* Explain plan
	* PL/SQL auto indentation
	* Statement statistics
	* Error location indication
	* SQL syntax highlighting
	* Code completion
	* Visualization of result
	* PL/SQL block parsing
	* Statement statistics comparison
* Schema browser
	* Table & view editing
	* References & dependencies
	* Reverse engeneering of objects
	* Tab & tree based browsing
	* Object & data filtering
* PL/SQL Editor/Debugger
	* Breakpoints
	* Watches
	* Line stepping
	* SQL Output viewing
	* Structure tree parsing
* Server tuning
	* Server overview
	* Tuning charts
	* Wait state analyzer
	* I/O by tablespace & file
	* Performance indicators
	* Server statistics
	* Parameter editor (P-file editor)
* Security manager
* Storage manager with object & extent viewer

* Session manager
* Rollback manager with snapshot too old detection
* SGA and long operations trace
* Current session information

* PL/SQL profiler
* Explain plan browser
* Statistics manager
* DBMS alert tool
* Invalid object browser
* SQL Output viewer
* Database/schema comparison and search
* Extract schema objects to SQL script

* Easily extendable
* Possible to add support for new or older Oracle versions without programming.
* SQL template help
* Full UNICODE support
* Printing of any list, text or chart

For installation instructions se the file INSTALL.

TOra is developed by a community of Open Source developers. The original 
(pre 1.3.15) development was done by Henrik Johnson of Quest Software, Inc.

The homepage for the TOra project is http://tora.sourceforge.net. If you 
encounter problems you can find both mailinglists and bugtracking tools 
from this page.

Oracle is copyright of Oracle Corporation.

%package oracle
Summary:		Oracle specific plugins for %{_name}
Group:			Development/Databases
Requires:		%{_name} = %{_version}
Autoreq:		0

%description oracle
Oracle specific plugins for %{_name}. This plugin will require a valid installation
of an Oracle Client of version 8.1 or later to function that can be downloaded by
a free registration from Oracle Technet from http://technet.oracle.com. NOTE: You
will require to download the entire server distribution to install the client, but
it is available as a choice in the installer.

%changelog
* Mon Jun 29 2005 Nathan Neulinger <nneul@umr.edu>
- standardize on a single tora spec file

%prep
%setup -q

export LD_LIBRARY_PATH="$LD_LIBRARY_PATH:$ORACLE_HOME/lib"

export CFLAGS="$RPM_OPT_FLAGS"
export CXXFLAGS="$RPM_OPT_FLAGS"

./configure \
	 --prefix="%{_prefix}" \
	 --bindir="%{_prefix}/bin" \
	 --libdir="%{_prefix}/lib" \
	--with-qt=$QTDIR \
	--with-qt-libraries=$QTDIR/lib \
	--with-qt-includes=$QTDIR/include \
	--without-kde

%build

%{__make}
# seemed to break build on mdk
#%{__strip} .libs/*.so 

# Ugly hack to remove version from libclntsh.so, if someone knows a better way please let me know
perl -pi -e 's/libclntsh.so.\d\d.\d\d/libclntsh.so\0\0\0\0\0\0/g' .libs/libtooracleconnection.so
perl -pi -e 's/libclntsh.so.\d\d.\d/libclntsh.so\0\0\0\0\0/g' .libs/libtooracleconnection.so
perl -pi -e 's/libclntsh.so.\d.\d/libclntsh.so\0\0\0\0/g' .libs/libtooracleconnection.so


%install

%{__rm} -rf "${RPM_BUILD_ROOT}" 
%{__mkdir_p} "${RPM_BUILD_ROOT}%{_prefix}/bin"
%{__mkdir_p} "${RPM_BUILD_ROOT}%{_prefix}/lib/tora/help"
%{__mkdir_p} "${RPM_BUILD_ROOT}%{_prefix}/lib/tora/help/images"
%{__mkdir_p} "${RPM_BUILD_ROOT}%{_prefix}/lib/tora/help/api"
%{__mkdir_p} "${RPM_BUILD_ROOT}%{_iconsdir}/hicolor/16x16/apps"
%{__mkdir_p} "${RPM_BUILD_ROOT}%{_iconsdir}/hicolor/32x32/apps"
%{__make} DESTDIR="${RPM_BUILD_ROOT}" install

%{__install} --mode=644 help/*.html "${RPM_BUILD_ROOT}%{_prefix}/lib/tora/help/"
%{__install} --mode=644 help/images/*.png "${RPM_BUILD_ROOT}%{_prefix}/lib/tora/help/images/"
%{__install} --mode=644 help/api/*.html "${RPM_BUILD_ROOT}%{_prefix}/lib/tora/help/api/"

%{__install} --mode=644 icons/tora.xpm "${RPM_BUILD_ROOT}%{_iconsdir}/hicolor/32x32/apps/tora.xpm"
%{__install} --mode=644 icons/toramini.xpm "${RPM_BUILD_ROOT}%{_iconsdir}/hicolor/16x16/apps/tora.xpm"

%post

%postun


%files 
%defattr(-,root,root)
%doc BUGS INSTALL LICENSE.txt NEWS README TODO
%{_prefix}/bin/*
%{_prefix}/lib/*.a
%{_prefix}/lib/*.la
%{_prefix}/lib/*.so
%dir %{_prefix}/lib/tora
#%{_prefix}/lib/tora/*.tpl
#%{_prefix}/lib/tora/*.qm
%{_prefix}/lib/tora/help
#%{_menudir}/tora
%{_iconsdir}/hicolor/*/apps/tora.xpm
#%{_datadir}/applnk/Development/tora.desktop

#%files oracle -f rpmoracle
#%defattr(-,root,root)

%clean
%{__rm} -rf "${RPM_BUILD_ROOT}"
