-- test/test-tongue.lua
--
-- Lua I18N library 'Tongue' -- Tests for the core Tongue module
--
-- Copyright 2016 Daniel Silverstone <dsilvers@digital-scurf.org>
--
-- For Licence terms, see COPYING
--

-- Step one, start coverage

pcall(require, 'luacov')

local tongue = require 'tongue'

local testnames = {}

local real_assert = assert
local total_asserts = 0
local function assert(...)
   local retval = real_assert(...)
   total_asserts = total_asserts + 1
   return retval
end

local function add_test(suite, name, value)
   rawset(suite, name, value)
   testnames[#testnames+1] = name
end

local suite = setmetatable({}, {__newindex = add_test})


function suite.version_present()
   assert(tongue._VERSION, "Version number is missing")
end

function suite.abi_present()
   assert(tongue._ABI, "ABI number is missing")
end

function suite.version_string_present()
   assert(tongue.VERSION, "Version string is missing")
end

function suite.langpack_module_present()
   assert(tongue.langpack, "Language pack module not present")
end

function suite.transliteration_module_present()
   assert(tongue.transliteration, "Transliteration module not present")
   assert(tongue.translit, "Transliteration module not present")
   assert(tongue.t13n, "Transliteration module not present")
end

function suite.util_module_present()
   assert(tongue.util, "Util module not present")
end

function suite.codex_module_present()
   assert(tongue.codex, "Codex module not present")
end

local count_ok = 0
for _, testname in ipairs(testnames) do
--   print("Run: " .. testname)
   local ok, err = xpcall(suite[testname], debug.traceback)
   if not ok then
      print(err)
      print()
   else
      count_ok = count_ok + 1
   end
end

print(tostring(count_ok) .. "/" .. tostring(#testnames) .. " [" .. tostring(total_asserts) .. "] OK")

os.exit(count_ok == #testnames and 0 or 1)
