/*
** TleenX2 (Tlen.pl Client)
** Copyright (c) 2002-2003 Hubert Sokoowski <who_ami@tlen.pl>
**                         Pawe Biliski <rael@fr.pl>
**
** This code is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public License.
**
*/


#ifndef __UTILS_H__
#define __UTILS_H__

#include <gtk/gtk.h>
#include <time.h>

#define MAX_ZAWODY 13
#define MAX_POSZUKUJE 5
#define MAX_PLANY 2

#define GLADE_HOOKUP_OBJECT(component,widget,name) \
  gtk_object_set_data_full (GTK_OBJECT (component), name, \
    gtk_widget_ref (widget), (GtkDestroyNotify) gtk_widget_unref)


typedef enum {
	INFO,
	DEBUG,
	ERROR,
	WARNING
} TleenxPrintType;

void tleenx_print(TleenxPrintType type, const gchar *format, ...);

gboolean file_exists(const gchar *filename);

void wyjscie();
void wyloguj();
void search_list_clear();
void desc_list_clear();
void desc_list_add(gchar *s);
void desc_list_append(gchar *s);
void frees(gpointer d1, gpointer d2);
void status_button_set(int status);
void status_gg_button_set(int status);
void status_jabber_button_set(int status);
void info(gchar *info);//okno modalne z informacja
const gchar *textview_get_text(GtkWidget *textview);
void textview_append(GtkWidget *textview, const gchar *str, gint scroll,
                     const gchar *tag, const gchar *tag2);
void textview_append_pixmap(GtkWidget *textview, gint emots_num);
void textview_clear(GtkWidget *textview);
gchar *utf(const gchar *in);
gchar *fromutf(const gchar *in);
gchar *filenameutf(gchar *in);
gchar *filenamefromutf(gchar *in);
void scroll_down(GtkWidget *scroll);
void newmail(const gchar *from, const gchar *subject);
void update_preferences();
gchar *get_localtime(const time_t *t);
gint get_miliseconds (void);
void my_create_colorselectiondialog1(gint i);
void work_offline();
void work_online();
gpointer initialization(gpointer g);
void play_sound(gint sound);
GtkWidget *create_icon(gint status);
GtkWidget *j_create_icon(gint status);
GtkWidget *wp_create_icon(gint status);
GtkWidget *gg_create_icon(gint status);
GtkWidget *notify_create_icon(gint type);
void set_status(gint tlen_status);

extern gchar *statusy[];
extern gint t_status_map[];
extern gint j_status_map[];

#endif
