/****************************************************************************
    Copyright (C) 1987-2001 by Jeffery P. Hansen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
****************************************************************************/
/*
    Declarations for Gate operations.
*/
#ifndef __gates_h
#define __gates_h

/*
   Code numbers for gate types which require special handling.
*/
#define BLOCK 		0x1001
#define JOINT		0x1002
#define SWITCH		0x1003
#define DIP		0x1004
#define TAP		0x1005
#define LOGICIN		0x1006
#define LOGICOUT	0x1007
#define LOGICTRI	0x1008
#define REGISTER	0x1009
#define COMMENT		0x100a
#define LED		0x100b
#define FLIPFLOP	0x100c

/*
   Gate pad numbers for some of the gates.
*/
#define BLOCK_TIN 0
#define BLOCK_LIN 1
#define BLOCK_BIN 2
#define BLOCK_RIN 3
#define BLOCK_TOUT 4
#define BLOCK_LOUT 5
#define BLOCK_BOUT 6
#define BLOCK_ROUT 7
#define BLOCK_TTRI 8
#define BLOCK_LTRI 9
#define BLOCK_BTRI 10
#define BLOCK_RTRI 11

#define REGISTER_OUT 0
#define REGISTER_IN 1
#define REGISTER_EN 2
#define REGISTER_CLR 3
#define REGISTER_CK 4

#define FLIPFLOP_Q 	0
#define FLIPFLOP_NQ	1
#define FLIPFLOP_IN	2
#define FLIPFLOP_EN	3
#define FLIPFLOP_CLR	4
#define FLIPFLOP_CK	5

#define LOGICIN_OUT 0
#define LOGICOUT_IN 0
#define TRI_OUT 0
#define DIP_OUT 0
#define TAP_TAP 0
#define TAP_IN 1
#define TAP_OUT 2

void gate_add(GModuleDef*,GCElement *);
void gate_remove(GModuleDef*,GCElement *);
GCElement *gate_new(int x,int y,int rot,int type);
int gate_delete(GCElement *g,GModuleDef *env,int drawp);
GCElement *gate_hit(GModuleDef*,int,int);
void gate_displayall(EditState *es,GModuleDef *mdef);
void gate_draw(GCElement *g,int md);
void gate_drawgatename(GCElement *g,char*);
void gate_namegate(GCElement *g,EditState *es);
void gate_move(GCElement *g,int x,int y);
void gate_mark(GCElement *g,int select);
void gate_getbbx(GCElement *g,int *minx,int *miny,int *maxx,int *maxy);
void gate_doReplication(EditState *es);
void gate_repgate(EditState *es,GCElement *g,int x,int y);
void gate_setinvertwirelist(GWire *nw,GWire *w);
void gate_hashrepline(EditState *es,int x,int y);
GCElement *gate_lookup(char *name,GModuleDef *mdef);
void gate_moveTo(GCElement *g,int x,int y);
void gate_setName(GCElement *g,char *name,GModuleDef *mdef);
void gate_cutOffWires(GCElement *g,GModuleDef *M,int drawp);
void gate_transmute(GCElement *g,GGateInfo *ngi);
void gate_moveObject(GCElement *g,int dx,int dy);
void gate_drawWires(GCElement *g,int md);
void gate_unattachwirelist(GWire *w,GModuleDef *env,int drawp);

void block_setWireEnd(GCElement *g,GWire *w,int pad);
GWire *block_hitPort(GCElement *g,int x,int y);

int GGateInfo_getPadNum(GGateInfo *gi,char *pname);

void gateinfo_iconInit(GGateInfo *gi,Pixmap P,iconDimensions *id,int boldOffset);
void gateinfo_1iconInit(GGateInfo *gi,Pixmap P,iconDimensions *id,int boldOffset);

void RegisterGate(GGateInfo *gi);


#endif
