/****************************************************************************
    Copyright (C) 1987-2001 by Jeffery P. Hansen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Last edit by hansen on Thu Jun 22 20:20:25 2000
****************************************************************************/
#include "tkgate.h"

#define ADDER_A 0
#define ADDER_B 1
#define ADDER_S 2
#define ADDER_CI 3
#define ADDER_CO 4

static iconDimensions add_iconDims[] = {
  {0,  0,  59, 28, 29, 15},
  {60, 0,  28, 59, 15, 29},
  {29, 60, 59, 28, 28, 12},
  {0,  29, 28, 59, 12, 29},
};
static int add_iconBoldOffset = 89;

struct locate adder_A_loc[] = {
	{-16,-16,-16,-16,D_UP},
	{-16,16,-16,16,D_LEFT},
	{16,16,16,16,D_DOWN},
	{16,-16,16,-16,D_RIGHT}};

struct locate adder_B_loc[] = {
	{16,-16,16,-16,D_UP},
	{-16,-16,-16,-16,D_LEFT},
	{-16,16,-16,16,D_DOWN},
	{16,16,16,16,D_RIGHT}};

struct locate adder_Ci_loc[] = {
	{24,-2,24,-2,D_RIGHT},
	{-2,-24,-2,-24,D_UP},
	{-24,2,-24,2,D_LEFT},
	{2,24,2,24,D_DOWN}};

struct locate adder_Co_loc[] = {
	{-24,-2,-24,-2,D_LEFT},
	{-2,24,-2,24,D_DOWN},
	{24,2,24,2,D_RIGHT},
	{2,-24,2,-24,D_UP}};


struct locate adder_S_loc[] = {
	{0,13,0,13,D_DOWN},
	{13,0,13,0,D_RIGHT},
	{0,-13,0,-13,D_UP},
	{-13,0,-13,0,D_LEFT}};

static char *psAdder[] = {
  "%",
  "% x y r adder",
  "%",
  "/psadder {",
  "  startgate",
  "  -30 15.5 moveto",
  "  -5 15.5 lineto",
  "  0 10 lineto",
  "  5 15.5 lineto",
  "  30 15.5 lineto",
  "  16 -12.5 lineto",
  "  -16 -12.5 lineto",
  "  closepath stroke",
  "  -3 0 moveto 3 0 lineto stroke",
  "  0 3 moveto 0 -3 lineto stroke",
  "  19 2 2 0 360 arc closepath fill",
  "  grestore",
  "} def",
  0
};

GGateInfo gate_add_info = {
  0,
  "Adder",
  "add",0x0,
  "psadder",psAdder,

  {{"+",	{"gmalu",0},		{"gmadd",0,0,100},	"gat_make add"},
   0},

  add_iconDims,

  5,{{"A",IN,8,1,adder_A_loc},
       {"B",IN,8,1,adder_B_loc},
       {"S",OUT,8,1,adder_S_loc},
       {"CI",IN,1,1,adder_Ci_loc},
       {"CO",OUT,1,1,adder_Co_loc}},
  {{24,10,LJ},{8,-24,LJ},{-24,-8,RJ},{-12,24,RJ}},
  {1},

  {"A/B-S","A/B-CO","CI-S","CI-CO",0},
  
  Generic_Make,
  Generic_Init,
  Generic_Delete,
  Generic_GetExtents,
  Generic_HitDistance,
  Generic_Draw,
  Generic_Move,
  Generic_Replicate,
  Err_AddInput,
  Err_AddOutput,
  Err_AddInOut,
  Err_ChangePin,
  Nop_SimStateFunc,
  Nop_SimHitFunc,
  Generic_PSWrite,
  Generic_EditProps,
  Generic_VerSave
};

void init_adder()
{
  Pixmap P;

  P = Pixmap_registerFromFile("add","add.b");
  gateinfo_iconInit(&gate_add_info,P,add_iconDims,add_iconBoldOffset);
  RegisterGate(&gate_add_info);
}
