/****************************************************************************
    Copyright (C) 1987-2001 by Jeffery P. Hansen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
****************************************************************************/
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "gsim.h"

#define SUPPLY_Z	0

static void Supply_initGate(EvQueue*,SGate*);

static SGateInfo supply_info = {
  0,
  "supply0:supply1",0x1,
  1,{{"Z",GIO_OUT,PF_CONST|PF_CUT}},

  {0},

  Generic_copyGate,
  Nop_processEvent,
  Nop_checkGate,
  Supply_initGate
};

void init_supply()
{
  SGateInfo_register(&supply_info,0);
}

static void Supply_initGate(EvQueue *Q,SGate *g)
{
  SPort *Z = g->g_ports.port[SUPPLY_Z];
  SState *S = alloc_SState();

#if 0
  if (g->g_ports.port[SUPPLY_Z]->p_comp)
    SState_one(S);
  else
    SState_zero(S);
#endif

  SState_zero(S);

  EvQueue_setPort(Q,Z,S,0);
}

