#   Copyright (C) 1987-2001 by Jeffery P. Hansen
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
# Last edit by hansen on Tue Sep 19 21:45:38 2000
#

set runlogo_state -1
set runlogo_speed 100

proc tkg_setDisplayFile {n} {
  global tkg_displayFile

  set p [string last "/" $n]
  if { $p >= 0 } {
    set n [string range $n [expr $p + 1] end]
  }

  set tkg_displayFile $n
}

proc updateStatus args {
  global tkg_displayFile tkg_currentBlock tkg_modifiedFlag tkg_statusMessage

  if { $tkg_modifiedFlag } {
     set mod "*"
  } else {
     set mod ""
  }
  
  .status.file configure -text "[m ifile]: $tkg_displayFile$mod"
  .status.block configure -text "[m imodule]: $tkg_currentBlock"
  .status.msg configure -text "$tkg_statusMessage" -anchor w
}

proc tkg_resetLogo {} {
  global bd runlogo_state

  catch {
    .status.logo configure -bitmap "@$bd/rungate1.xbm"
    set runlogo_state 1
  }
}

proc tkg_pauseLogo {} {
  global bd runlogo_ev

  catch { after cancel $runlogo_ev }
}

proc rkg_stepRunLogo {} {
  global bd runlogo_state runlogo_speed runlogo_ev

  catch {
    .status.logo configure -bitmap "@$bd/rungate${runlogo_state}.xbm"
    set runlogo_state [expr $runlogo_state + 1 ]
    if { $runlogo_state > 14 } {
      set runlogo_state 1
    }
    set runlogo_ev [after $runlogo_speed rkg_stepRunLogo]
  }
}

proc tkg_runLogo {} {
  global bd runlogo_speed runlogo_ev

  catch {
    catch { after cancel $runlogo_ev }
    set runlogo_ev [after $runlogo_speed rkg_stepRunLogo]
  }
}

proc tkg_editLogo {} {
  global bd runlogo_ev

  catch {
    catch { after cancel $runlogo_ev }
    .status.logo configure -bitmap "@$bd/gatelogo.xbm"
  }
}

proc tkg_analysisLogo {} {
  global bd runlogo_ev

  catch {
    catch { after cancel $runlogo_ev }
    .status.logo configure -bitmap "@$bd/anallogo.xbm"
  }
}

after [expr $tkg_checkpointFreq * 1000] tkg_checkpointReq
proc tkg_checkpointReq {} {
  global tkg_wantCheckpoint tkg_checkpointEnabled tkg_checkpointFreq

  if { $tkg_checkpointEnabled } {
    set tkg_wantCheckpoint 1
  }
    after [expr $tkg_checkpointFreq * 1000] tkg_checkpointReq
}


frame .status.aux
label .status.file 
label .status.block
label .status.msg -font $body_font -relief groove -padx 5 -pady 5
label .status.logo -relief groove -bitmap "@$bd/gatelogo.xbm"

pack .status.logo -side right -ipadx 5 -ipady 5 -padx 5
pack .status.msg -side bottom -padx 10 -pady 5 -fill x
pack .status.aux -side right
pack .status.file .status.block -side left -padx 10 -pady 3 -fill x 

updateStatus

trace variable tkg_displayFile w updateStatus
trace variable tkg_currentBlock w updateStatus
trace variable tkg_modifiedFlag w updateStatus
trace variable tkg_statusMessage w updateStatus

helpon .status.logo [m ho.status.logo]

helpon .status.msg [m ho.status.msg]
helpon .status.block [m ho.status.block]
helpon .status.file [m ho.status.file]
