proc annotate_view { file } {
#
# show information on the last modification for each line of a file.
#
  global cvs
  global cvscfg
  global current_tagname
  global agecolors
  global revcolors

  gen_log:log T "ENTER ($file)"

  # name the window - gotta get the dots out of the filename 
  # and still have it unique
  regsub -all {\.} $file "-dot-" winnam
  regsub -all { } $winnam "_" winnam
  gen_log:log D "global log_$winnam"
  global log_$winnam

  set cvsannotate .cvsannotate$winnam
  set mtime [file mtime $file]

  if {[llength $current_tagname] == 1} {
    # We have a branch here
    set commandline "$cvs -d $cvscfg(cvsroot) annotate -r$current_tagname \"$file\" 2>$cvscfg(null)"
  } else {
    set commandline "$cvs -d $cvscfg(cvsroot) annotate \"$file\" 2>$cvscfg(null)"
  }

  # Initialize searching
  search_textwidget_init

  if {![winfo exists $cvsannotate]} {
    # Make the window 
    toplevel $cvsannotate
    text $cvsannotate.text -setgrid yes -relief sunken -border 2 \
      -height 40 -width 122 -yscroll "$cvsannotate.scroll set"
    scrollbar $cvsannotate.scroll -relief sunken \
      -command "$cvsannotate.text yview"
  
  
    frame $cvsannotate.bottom
    button $cvsannotate.bottom.close -text "Close" \
      -command "unset log_$winnam; destroy $cvsannotate"
  
    label $cvsannotate.bottom.days -text "Days per Color" \
      -width 20 -anchor e
    entry $cvsannotate.bottom.dayentry -width 3 \
      -textvariable cvscfg(dayspercolor)
    bind $cvsannotate.bottom.dayentry <Return> \
      "annotate_view \"$file\""
    button $cvsannotate.bottom.redo -text "Redo Colors" \
      -command "annotate_view \"$file\""
  
    button $cvsannotate.bottom.srchbtn -text Search \
      -command "search_textwidget $cvsannotate.text"
    entry $cvsannotate.bottom.entry -width 20 -textvariable cvsglb(searchstr)
    bind $cvsannotate.bottom.entry <Return> \
        "search_textwidget $cvsannotate.text"
  
    pack $cvsannotate.bottom -side bottom -fill x
    pack $cvsannotate.bottom.srchbtn -side left
    pack $cvsannotate.bottom.entry -side left
    pack $cvsannotate.bottom.days -side left
    pack $cvsannotate.bottom.dayentry -side left
    pack $cvsannotate.bottom.redo -side left
    pack $cvsannotate.bottom.close -side right -ipadx 15
  
    pack $cvsannotate.scroll -side right -fill y
    pack $cvsannotate.text -fill both -expand 1
    
    wm title $cvsannotate "CVS Annotate $file"

    # Define the colors
    array set agecolors {
        0 #FFFF4B4B4B4B
        1 #FFFF6C6C4B4B
        2 #FFFF82824B4B
        3 #FFFF97974B4B
        4 #FFFFA8A84B4B
        5 #FFFFB4B44B4B
        6 #FFFFC5C54B4B
        7 #FFFFDBDB4B4B
        8 #FFFFFCFC4B4B
        9 #DBDBFFFF4B4B
        10 #ACACFFFF4B4B
        11 #7575FFFF4B4B
        12 #4F4FFFFF4B4B
        13 #4B4BFFFFB4B4
        14 #4B4BFFFFDFDF
        15 #4B4BF4F4FFFF
        16 #4B4BDFDFFFFF
        17 #4B4BD2D2FFFF
        18 #4B4BB0B0FFFF
        19 #4B4B8686FFFF
        20 #4B4B7979FFFF
        21 #4B4B6464FFFF
        22 #4B4B5757FFFF
        23 #4B4B4B4BFFFF
    }

  gen_log:log C "$commandline"
  catch {eval "exec $commandline"} log_$winnam
  } else {
    $cvsannotate.text delete 1.0 end
  }

  # Since there's an entry for changing dayspercolor, make sure it's
  # something you can divide by or it will produce an error.
  if {[string length $cvscfg(dayspercolor)] == 0 || \
     $cvscfg(dayspercolor) == 0 || \
     [regexp {\D+} $cvscfg(dayspercolor)]} {
    gen_log:log D " dayspercolor was \"$cvscfg(dayspercolor)\": setting to 1"
    set cvscfg(dayspercolor) 1
  }

  # Read the log lines.  Assign a color to each unique revision.
  catch {unset revcolors}
  set log_lines [split [set log_$winnam] "\n"]
  #gen_log:log D "$logline"
  busy_start $cvsannotate
  foreach logline $log_lines {
    annotate_color_granny $cvsannotate.text $mtime $logline
  }
  $cvsannotate.text configure -state disabled
  # Focus in the text widget to activate the text bindings
  focus $cvsannotate.text
  #bind_show $cvsannotate.text -verbose
  busy_done $cvsannotate
}

proc annotate_color_granny {w mtime logline} {
  global cvscfg
  global revcolors
  global agecolors

  #gen_log:log T "ENTER $w $mtime $logline"

  set line [split $logline]
  #gen_log:log D "$line"
  set revnum [lindex $line 0]

  # Beginning of a revision
  if { ! [info exists revcolors($revnum)] } {
    #gen_log:log D " revision $revnum needs new color"
    # get the date of the revision and determine the number of days
    # between this commit and the mtime, then set color accordingly
    set revdate [string range $logline 23 31]
    regsub -all -- {-} $revdate " " revdate
    #set revticks [expr [clock seconds] - [clock scan $revdate]]
    set revticks [expr $mtime - [clock scan $revdate]]
    # array is in increments of dayspercolor days 
    # 60 * 60 * 24 = 86400 sec.
    set revindex [expr $revticks / (86400 * $cvscfg(dayspercolor))]
    set ncolors [expr {[array size agecolors] - 1}]
    if { $revindex > $ncolors } { set revindex $ncolors }
    if { $revindex < 0 } { set revindex 0 }

    set revcolors($revnum) $agecolors($revindex)

    $w tag configure $revnum \
      -background $revcolors($revnum) -foreground black
    gen_log:log D "$w tag configure $revnum $revcolors($revnum)"
    #$w tag lower $revnum 
  } else {
    #gen_log:log D " revision $revnum already has a color"
  }

  $w insert end "$logline\n" $revnum
}

