
rename ck_popup ck_popup:old
proc ck_popup {args} {
    update idletasks
    return [eval ck_popup:old $args]
}

namespace eval PanedWindow {
    proc ::PanedWindow {path args} {
	return [eval PanedWindow::create $path $args]
    }
    proc ::PanedWin {path args} {
	return [eval PanedWindow::create $path $args]
    }
}

proc PanedWindow::create {path args} {
    variable data

    set data($path,side) bottom
    foreach {opt val} $args {
	switch -- $opt {
	    -side { set data($path,side) $val }
	}
    }

    set data($path,numpanes) 0
    frame $path -class PanedWindow

    bind $path <Destroy> [list PanedWindow::_end $path]

    rename $path ::$path:cmd
    proc ::$path {cmd args} "return \[eval PanedWindow::\$cmd $path \$args\]"
    return $path
}

proc PanedWindow::add {path args} {
    variable data

    foreach {opt val} $args {
	switch -- $opt {
	    -weight { set weight $val }
	}
    }

    set num $data($path,numpanes)
    frame $path.f$num
    switch -- $data($path,side) {
	-top -
	-bottom {
	    if {[info exists weight]} {
		grid columnconfigure $path $num -weight $weight
	    }
	    grid $path.f$num -row 0 -column $num -sticky nwes
	}
	-left -
	-right {
	    if {[info exists weight]} {
		grid rowconfigure $path $num -weight $weight
	    }
	    grid $path.f$num -row $num -column 0 -sticky nwes
	}
    }
    incr data($path,numpanes)
    return $path.f$num
}

proc PanedWindow::getframe {path index} {
    return $path.f$index
}

proc PanedWindow::_end {path} {
    variable data

    array unset data $path,*
}

namespace eval NoteBook {
    proc ::NoteBook {path args} {
	return [eval NoteBook::create $path $args]
    }
}

proc NoteBook::create {path args} {
    variable data

    set data($path,pages) {}
    catch { unset data($path,current) }

    frame $path -class NoteBook
    set nbtabs [frame $path.tabs -height 1 -background red]
    pack $nbtabs -side top -fill x -expand no
    set nbfr [frame $path.fr -background yellow]
    pack $nbfr -side top -fill both -expand yes

    rename $path ::$path:cmd
    proc ::$path {cmd args} "return \[eval NoteBook::\$cmd $path \$args\]"
    return $path
}

proc NoteBook::insert {path index page args} {
    variable data

    if {[lsearch $data($path,pages) $page] != -1} {
	return -code error "page \"$page\" already exists"
    }

    set data($path,text,$page) ""
    foreach {opt val} $args {
	switch -- $opt {
	    -text { set data($path,text,$page) $val }
	    -raisecmd { set data($path,raisecmd,$page) $val }
	}
    }

    frame $path.f$page

    set data($path,pages) [linsert $data($path,pages) $index $page]
    return $path.f$page
}

proc NoteBook::raise {path {page ""}} {
    variable data

    if {![cequal $page ""] && ![cequal $data($path,current) $page} {
	_test_page $path $page
	_select $path $page
    }
    return $data($path,current)
}

proc NoteBook::getframe {path page} {
    return $path.f$page
}

proc NoteBook::_test_page {path page} {
    variable data

    if {[set pos [lsearch $data($path,pages) $page]] == -1} {
	return -code error "page \"$page\" does not exists"
    }
    return $pos
}

proc NoteBook::_select {path page} {
    variable data

    set old_current $data($path,current)
    set data($path,current) $page

    pack forget $old_current
    pack $page -fill both -expand yes
    if {[info exists data($path,raisecmd,$page)]} {
	set cmd $data($path,raisecmd,$page)
	set code [catch {uplevel \#0 $cmd} res]
	if { $code == 1 || $res == 0 } {
	    return -code $code $res
	}
    }
}

namespace eval MessageDlg {
    proc ::MessageDlg {path args} {
	return [eval MessageDlg::create $path $args]
    }
    variable title
    array set title [list none [::msgcat::mc "Message"] \
	info [::msgcat::mc "Information"] \
	question [::msgcat::mc "Question"] \
	warning [::msgcat::mc "Warning"] \
	error [::msgcat::mc "Error"]]
}

proc MessageDlg::create {path args} {
    variable title

    set icon none
    set newargs {}
    set message ""
    set aspect 320
    set type user
    set buttons {ok}
    foreach {opt val} $args {
	switch -- $opt {
	    -icon {
		if {[info exists title($val)]} {
		    set titl $title($val)
		}
	    }
	    -message { set message $val }
	    -type { set type $val }
	    -buttons { set buttons $val }
	    -aspect { set aspect $val }
	    default { lappend newargs $opt $val }
	}
    }
    if {![info exists titl]} {
	set titl [;;msgcat::mc "Message"]
    }
    lappend newargs -title $titl

    eval Dialog::create $path $newargs

    foreach b $buttons {
	switch -- $b {
	    ok { set opt [list -text [::msgcat::mc "OK"]] }
	    cancel { set opt [list -text [::msgcat::mc "Cancel"]] }
	}
	eval Dialog::add $path $opt
    }

    set frame [$path getframe]
    message $frame.msg -text $message -aspect $aspect
    pack $frame.msg -side left -fill x -expand yes

    set res [Dialog::draw $path]
    catch { destroy $path }
    return $res
}

namespace eval Bitmap {
}

proc Bitmap::get {args} {
    return ""
}

rename message message:old
proc message {path args} {
    set newargs {}
    foreach {opt val} $args {
	switch -- $opt {
	    -relief {}
	    -borderwidth {}
	    -highlightthickness {}
	    default { lappend newargs $opt $val }
	}
    }
    return [eval message:old $path $newargs]
}

rename menu menu:old
proc menu {path args} {
    set newargs {}
    foreach {opt val} $args {
	switch -- $opt {
	    -tearoff {}
	    default { lappend newargs $opt $val }
	}
    }
    return [eval menu:old $path $newargs]
}

rename menubutton menubutton:old
proc menubutton {path args} {
    set newargs {}
    foreach {opt val} $args {
	switch -- $opt {
	    -font {}
	    -relief {}
	    default { lappend newargs $opt $val }
	}
    }
    return [eval menubutton:old $path $newargs]
}

namespace eval Dialog {
    proc ::Dialog {path args} {
	return [eval Dialog::create $path $args]
    }
}

proc Dialog::create {path args} {
    variable modal
    variable bwidth

    if {[llength $args] <= 0} {
	return -1
    }
    catch {destroy $path}
    toplevel $path -class Dialog
    set title ""
    set separator 0
    set modal($path) local
    set bwidth($path) 6
    foreach {opt val} $args {
	switch -- $opt {
	    -title { set title $val }
	    -separator { set separator $val }
	    -modal { set modal($path) $val }
	    -default { 
		bind $path <Key-Return> \
		    "if \{\[winfo exists $path.b.b$val\]\} \{ $path.b.b$val invoke \}"
	    }
	    -cancel { 
		bind $path <Key-Escape><Key-Escape> "$path.b.b$val invoke"
	    }
	}
    }
    bind $path <Destroy> "Dialog::end $path"
    if {[string length $title] > 0} {
	label $path.title -text " $title "
	place $path.title -y 0 -relx 0.5 -anchor center -bordermode ignore
    }
    frame $path.sep0 -border {} -height 1
    pack $path.sep0 -side top -fill x
    frame $path.frame
    pack $path.frame -side top
    if {$separator} {
	frame $path.sep1 -border hline -height 1
	pack $path.sep1 -side top -fill x
    }
    frame $path.b
    pack $path.b -side top -fill x

    rename $path ::$path:cmd
    proc ::$path {cmd args} "return \[eval Dialog::\$cmd $path \$args\]"
    return $path
}

proc Dialog::getframe {path args} {
    return $path.frame
}

proc Dialog::add {path args} {
    variable buttons
    variable bwidth
    variable result

    if {![info exists buttons($path)]} {
	set buttons($path) 0
    } else {
	incr buttons($path)
    }
    set text ""
    set command "Dialog::enddialog $path [set [namespace current]::buttons($path)]
		 destroy $path"
    foreach {opt val} $args {
	switch -- $opt {
	    -text { set text $val }
	    -command { set command $val }
	}
    }
    button $path.b.b$buttons($path) -text $text -command $command \
	-width $bwidth($path)
    pack $path.b.b$buttons($path) -side left -ipadx 1 -expand yes
    set width [winfo reqwidth $path.b.b$buttons($path)]
    if {$width > $bwidth($path)} {
	for {set i 0} {$i <= $buttons($path)} {incr i} {
	    $path.b.b$i configure -width $width
	}
	set bwidth($path) $width
    }
}

proc Dialog::draw {path args} {
    variable modal
    variable result
    
    place $path -relx 0.5 -rely 0.5 -anchor center
    if {[llength $args]} {
	set focus [lindex $args 0]
    } else {
	set focus $path.b.b0
    }
    focus $focus
    if {![cequal $modal($path) none]} {
	vwait [namespace current]::result($path)
	catch { place forget $path }
	return $result($path)
    } else {
	return ""
    }
}

proc Dialog::enddialog {path args} {
    variable result

    set result($path) [lindex $args 0]
}

proc Dialog::end {path} {
    variable buttons
    variable result
    variable modal
    variable bwidth

    set result($path) -1
    catch { unset buttons($path) result($path) modal($path) bwidth($path) }
}

namespace eval Text {
    variable tag_bindings

    rename text ::text:old
    proc ::text {path args} {
	return [eval Text::create $path $args]
    }
}

proc Text::create {path args} {
    variable tag_bindings

    set newargs {}
    foreach {opt val} $args {
	switch -- $opt {
	    -font {}
	    default { lappend newargs $opt $val }
	}
    }
    eval text:old $path $newargs
    bind $path <Destroy> [list array unset tag_bindings "$path,*"]
    rename $path ::$path:cmd
    proc ::$path {cmd args} "return \[eval Text::cmd $path \$cmd \$args\]"
    return $path
}

proc Text::cmd {path cmd args} {
    if {[cequal $cmd tag] && [cequal [lindex $args 0] bind]} {
	return [eval Text::bindtag $path [lrange $args 1 end]]
    } else {
	return [eval $path:cmd $cmd $args]
    }
}

proc Text::bindtag {path args} {
    variable tag_bindings

    set tag [lindex $args 0]
    set sequence [lindex $args 1]
    set script [lrange $args 2 end]
    set tag_bindings($path,$tag,$sequence) $script
    bind $path $sequence [list Text::bindscript $path $sequence %x %y %X %Y]
}

proc Text::bindscript {path sequence x y X Y} {
    variable tag_bindings

    foreach tag [$path tag names @$x,$y] {
	if {[info exists tag_bindings($path,$tag,$sequence)]} {
	    regsub {%X} $tag_bindings($path,$tag,$sequence) $X cmd
	    regsub {%Y} $cmd $Y cmd
	    eval eval $cmd
	}
    }
}

namespace eval ScrolledWindow {
    proc ::ScrolledWindow {path args} {
	return [eval ScrolledWindow::create $path $args]
    }
}

proc ScrolledWindow::create {path args} {
    variable data
    set newargs {}
    set data($path,sb) both
    foreach {opt val} $args {
	switch -- $opt {
	    -scrollbar { set data($path,sb) $val }
	    default { lappend newargs $opt $val }
	}
    }
    eval frame $path $newargs
    rename $path ::$path:cmd
    proc ::$path {cmd args} "return \[eval ScrolledWindow::cmd $path \$cmd \$args\]"
    return $path
}

proc ScrolledWindow::cmd {path cmd args} {
    switch -- $cmd {
	setwidget {
	    if {[llength $args] != 1} {
		return -class error {Incorrect number of args}
	    }
	    set sib [lindex $args 0]
	    debugmsg sw $sib
	    $sib configure -yscrollcommand "ScrolledWindow::scroll $path $sib y" \
			   -xscrollcommand "ScrolledWindow::scroll $path $sib x"
	    scrollbar $path.ysb -orient vertical -command "$sib yview"
	    scrollbar $path.xsb -orient horizontal -command "$sib xview"
 
	    grid rowconfigure $path 0 -weight 1
	    grid rowconfigure $path 1 -weight 0
	    grid columnconfigure $path 0 -weight 1
	    grid columnconfigure $path 1 -weight 0

	    grid $sib -row 0 -column 0 -sticky nsew
	    grid $path.ysb -row 0 -column 1 -sticky ns
	    grid $path.xsb -row 1 -column 0 -sticky ew
        }
        default {
	   return [eval ::$path:cmd $cmd $args]
        }
    }
}

proc ScrolledWindow::scroll {path sib dir min max} {

    switch -- $dir {
	x { 
	    set unit row
	    set unit2 column
	    set opp y
	}
	y { 
	    set unit column
	    set unit2 row
	    set opp x
	}
    }
    
    foreach {opt val} [grid info $sib] {
	switch -- $opt \
	    -${unit}span {
		set cur $val
	    } \
	    -${unit2}span {
		set sbspan $val
	    }
    }
    if {($min == 0) && ($max == 1)} {
	set des 2
    } else {
	set des 1
    }
    if {$des != $cur} {
	grid configure $sib -${unit}span $des
	grid configure $path.${opp}sb -${unit}span $des
	grid configure $path.${dir}sb -${unit2}span $sbspan
    }
    update idletasks
    $path.${dir}sb set $min $max		    
}

