/***************************************************************************
 *   copyright            : (C) 1999 by Daniel Reith                       *
 *   email                : DanR@gmx.de                                    *
 *                                                                         *
 *   copyright           : (C) 2003 by Hendrik Sattler                     *
 *   mail                : pingos@hendrik-sattler.de                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "dirs.H"
#include "KursBeginWizard.H"
#include "commonElements.H"

KursBeginWizard::KursBeginWizard (wxWindow* parent)
  : wxWizard()
{
  LessonPath logopath;
  logopath.setFullFileName(_T("wizard.png"));  
  wxBitmap* bmp = common::getBitmap(logopath);
  wxString title = _("Start a new class");
  if (bmp != 0) {
    Create(parent,-1,title,*bmp);
  } else {
    Create(parent,-1,title);
  }

  // Seite 1 des Wizards erzeugen und mit Items fllen
  this->p1 = new KursWaehlenSeite(this);
  // Seite 2 des Wizards erzeugen
  this->p2 = new NameEingebenSeite(this);
  // Seite 3 erzeugen
  this->p3 = new wxWizardPageSimple(this);
  this->p3text = new wxStaticText(p3,-1,wxString::Format(_("Now, we have all the needed information.\nPlease press \"%s\" to start the class\nwith the first lesson."),_("Finish")));
  wxBoxSizer* pageSizer = new wxBoxSizer(wxVERTICAL);
  pageSizer->Add(this->p3text);
  pageSizer->Add(0,0,1);
  this->p3->SetSizer(pageSizer);
  pageSizer->SetSizeHints(this->p3);
  

  // Reihenfolge der Seiten festlegen
  wxWizardPageSimple::Chain(this->p1, this->p2);
  wxWizardPageSimple::Chain(this->p2, this->p3);
  FitToPage(this->p1);
}

KursBeginWizard::~KursBeginWizard () {
  delete p1;
  delete p2;
  delete p3;
}

bool KursBeginWizard::runWizard () {
  return RunWizard(this->p1);
}

int KursBeginWizard::getKursNummer () {
  return this->p1->GetSelection()+1;
}

wxString KursBeginWizard::getName () {
  return this->p2->GetName();
}

BEGIN_EVENT_TABLE(KursWaehlenSeite,wxWizardPageSimple)
  EVT_WIZARD_PAGE_CHANGING(wxID_ANY,KursWaehlenSeite::OnPageChanging)
  EVT_WIZARD_PAGE_CHANGED(wxID_ANY,KursWaehlenSeite::OnPageEnter)
END_EVENT_TABLE()

#include "commonElements.H"

KursWaehlenSeite::KursWaehlenSeite (wxWizard *parent)
  : wxWizardPageSimple(parent)
{
  // Kursinformationen auslesen
  LessonPath filename;
  filename.appendDir(TtConfigFile::getPtr()->getKeyboardLayout());
  filename.setFullFileName(_T("kurs.index"));
  wxURL* u = filename.getURL();
  wxInputStream* input = common::getInputStream(*u);
  if (input==0) {
    ::wxLogError(_("Cannot load file %s"), filename.getFullFileName().c_str());
    this->box=0;
  } else {
    this->ar = common::getIndexFile(*input);
    this->box = new wxRadioBox (this,-1,_("Please select a class"),
				wxDefaultPosition, wxDefaultSize,
				ar.GetCount(), common::toStringPtr(this->ar));
    wxBoxSizer* pageSizer = new wxBoxSizer(wxVERTICAL);
    //add the box, expand it horizontal and center it vertical
    pageSizer->Add(0,0,1);
    pageSizer->Add(box,0,wxEXPAND|wxALIGN_CENTER);
    pageSizer->Add(0,0,1);
    SetSizer(pageSizer);
    pageSizer->SetSizeHints(this);
  }
  delete input;
  delete u;
}

KursWaehlenSeite::~KursWaehlenSeite () {
}

void KursWaehlenSeite::OnPageChanging (wxWizardEvent& e) {
  if (e.GetDirection() == true) {
    if (this->box == 0 ||
	this->box->GetSelection() == -1) {
      wxMessageBox(_("You have to select a class!"),
		   _("Important!"), wxICON_WARNING | wxOK, this);
      e.Veto();
    } else {
      this->selection = this->box->GetSelection();
    }
  }
  return;
}

void KursWaehlenSeite::OnPageEnter (wxWizardEvent& WXUNUSED(e)) {
  if (this->box != 0) {
    this->box->SetFocus();
  }
}

BEGIN_EVENT_TABLE(NameEingebenSeite,wxWizardPageSimple)
  EVT_WIZARD_PAGE_CHANGING(wxID_ANY,NameEingebenSeite::OnPageChanging)
  EVT_WIZARD_PAGE_CHANGED(wxID_ANY,NameEingebenSeite::OnPageEnter)
END_EVENT_TABLE()

NameEingebenSeite::NameEingebenSeite(wxWizard *parent)
  : wxWizardPageSimple(parent) {
  this->text = new wxStaticText(this, -1,
				_("Please enter your name:"));
  this->tctrl = new wxTextCtrl(this, -1, ::wxGetUserId());
  //for sizer comments, see above
  wxBoxSizer* pageSizer = new wxBoxSizer(wxVERTICAL);
  pageSizer->Add(0,0,1);
  pageSizer->Add(text,0,wxBOTTOM,5);
  pageSizer->Add(tctrl,0,wxEXPAND);
  pageSizer->Add(0,0,1);
  SetSizer(pageSizer);
  pageSizer->SetSizeHints(this);
}

NameEingebenSeite::~NameEingebenSeite () {
}

void NameEingebenSeite::OnPageChanging (wxWizardEvent& e) {
  if (e.GetDirection() == true) {
    if (this->tctrl->GetValue() == _T("")) {
      wxMessageBox(_("Your have to enter a name!"),
		   _("Important"), wxICON_WARNING | wxOK, this);
      e.Veto();
    } else {
      this->name = this->tctrl->GetValue();
    }
  }
  return;
}

void NameEingebenSeite::OnPageEnter (wxWizardEvent& WXUNUSED(e)) {
  this->tctrl->SetFocus();
}
